/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import org.apache.log4j.Logger;

public class PermissionHelper {
    private static Logger log = Logger.getLogger(PermissionHelper.class);
    private PermissionManager permissionManager;
    private PersonalInformationManager personalInformationManager;

    public PermissionHelper() {
    }

    public PermissionHelper(PermissionManager permissionManager, PersonalInformationManager personalInformationManager) {
        this.permissionManager = permissionManager;
        this.personalInformationManager = personalInformationManager;
    }

    public boolean canEdit(User user, Object object) {
        return GeneralUtil.isSuperUser(user) || this.permissionManager.hasPermission(user, Permission.EDIT, object);
    }

    public boolean canView(User user, Object object) {
        return GeneralUtil.isSuperUser(user) || this.permissionManager.hasPermission(user, Permission.VIEW, object);
    }

    public boolean canRemove(User user, Object object) {
        return GeneralUtil.isSuperUser(user) || this.permissionManager.hasPermission(user, Permission.REMOVE, object);
    }

    public boolean canExport(User user, Object object) {
        return GeneralUtil.isSuperUser(user) || this.permissionManager.hasPermission(user, Permission.EXPORT, object);
    }

    public boolean canComment(User user, Object object) {
        return GeneralUtil.isSuperUser(user) || this.permissionManager.hasCreatePermission(user, object, Comment.class);
    }

    public boolean canAttachFile(User user, Object object) {
        return GeneralUtil.isSuperUser(user) || this.permissionManager.hasCreatePermission(user, object, Attachment.class);
    }

    public boolean isGlobalAdministrator(User user) {
        log.info((Object)"Template uses deprecated PermissionHelper.isGlobalAdministrator. Replace with $permissionHelper.isConfluenceAdministrator.");
        return GeneralUtil.isSuperUser(user) || this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public boolean isConfluenceAdministrator(User user) {
        return GeneralUtil.isSuperUser(user) || this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public boolean isSystemAdministrator(User user) {
        return GeneralUtil.isSuperUser(user) || this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    public boolean canCreatePage(User user, Space space) {
        return GeneralUtil.isSuperUser(user) || this.permissionManager.hasCreatePermission(user, space, Page.class);
    }

    public boolean canCreateBlogPost(User user, Space space) {
        return GeneralUtil.isSuperUser(user) || this.permissionManager.hasCreatePermission(user, space, BlogPost.class);
    }

    public boolean canAdminister(User user, Object object) {
        return GeneralUtil.isSuperUser(user) || this.permissionManager.hasPermission(user, Permission.ADMINISTER, object);
    }

    public boolean canRemoveMail(User user, Object object) {
        return GeneralUtil.isSuperUser(user) || this.permissionManager.hasPermission(user, Permission.REMOVE, Mail.class);
    }

    public boolean canCreatePersonalSpace(User user) {
        if (user == null) {
            return false;
        }
        return GeneralUtil.isSuperUser(user) || this.permissionManager.hasCreatePermission(user, this.personalInformationManager.getPersonalInformation(user), Space.class);
    }

    public boolean isGlobalAnonymousAccessEnabled() {
        return this.canView(null, PermissionManager.TARGET_APPLICATION);
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }
}

