/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.spaces.Space;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class SpacePermission
extends ConfluenceEntityObject
implements Serializable {
    public static final String FORM_PARAMETER_PREFIX = "confluence";
    public static final String FORM_PARAMETER_SEPARATOR = "_";
    public static final String FULL_FORM_PARAMETER_PREFIX = "confluence_";
    public static final String USE_CONFLUENCE_PERMISSION = "USECONFLUENCE";
    public static final String SYSTEM_ADMINISTRATOR_PERMISSION = "SYSTEMADMINISTRATOR";
    public static final String CONFLUENCE_ADMINISTRATOR_PERMISSION = "ADMINISTRATECONFLUENCE";
    public static final String ADMINISTER_CONFLUENCE_PERMISSION = "SYSTEMADMINISTRATOR";
    public static final String PERSONAL_SPACE_PERMISSION = "PERSONALSPACE";
    public static final String CREATE_SPACE_PERMISSION = "CREATESPACE";
    public static final String PROFILE_ATTACHMENT_PERMISSION = "PROFILEATTACHMENTS";
    public static final String VIEWSPACE_PERMISSION = "VIEWSPACE";
    public static final String COMMENT_PERMISSION = "COMMENT";
    public static final String CREATEEDIT_PAGE_PERMISSION = "EDITSPACE";
    public static final String ADMINISTER_SPACE_PERMISSION = "SETSPACEPERMISSIONS";
    public static final String REMOVE_PAGE_PERMISSION = "REMOVEPAGE";
    public static final String REMOVE_COMMENT_PERMISSION = "REMOVECOMMENT";
    public static final String REMOVE_BLOG_PERMISSION = "REMOVEBLOG";
    public static final String CREATE_ATTACHMENT_PERMISSION = "CREATEATTACHMENT";
    public static final String REMOVE_ATTACHMENT_PERMISSION = "REMOVEATTACHMENT";
    public static final String EDITBLOG_PERMISSION = "EDITBLOG";
    public static final String EXPORT_PAGE_PERMISSION = "EXPORTPAGE";
    public static final String EXPORT_SPACE_PERMISSION = "EXPORTSPACE";
    public static final String REMOVE_MAIL_PERMISSION = "REMOVEMAIL";
    public static final String SET_PAGE_PERMISSIONS_PERMISSION = "SETPAGEPERMISSIONS";
    public static final Collection PERMISSION_TYPES;
    public static final Collection GENERIC_SPACE_PERMISSIONS;
    public static final Collection GLOBAL_PERMISSIONS;
    public static final Collection INVALID_ANONYMOUS_PERMISSIONS;
    private static final Set DEFAULT_GLOBAL_PERMISSIONS;
    private String type;
    private Space space;
    private String group;
    private String userName;

    public static SpacePermission fromFormParameterName(String formParameterName, Space space, String parameterType) throws ParseException {
        String entityName;
        String[] splitUpCheckboxName = formParameterName.split(FORM_PARAMETER_SEPARATOR, 5);
        if (splitUpCheckboxName.length < 4) {
            throw new ParseException("Insufficient information in form parameter name: " + formParameterName, 0);
        }
        if (!FORM_PARAMETER_PREFIX.equals(splitUpCheckboxName[0])) {
            throw new ParseException("Wrong prefix in form parameter name: " + formParameterName, 0);
        }
        if (!parameterType.equals(splitUpCheckboxName[1])) {
            throw new ParseException("Wrong parameterType in form parameter name: " + formParameterName, 0);
        }
        String permissionType = splitUpCheckboxName[2].toUpperCase(Locale.ENGLISH);
        if (!PERMISSION_TYPES.contains(permissionType)) {
            throw new ParseException("Unrecognised permission type: " + permissionType + " in parameter " + formParameterName, 0);
        }
        String entityType = splitUpCheckboxName[3];
        boolean isAnonymous = "anonymous".equals(entityType);
        if (isAnonymous) {
            return new SpacePermission(permissionType, space, null, null);
        }
        try {
            entityName = splitUpCheckboxName[4];
            if (StringUtils.isBlank((String)entityName)) {
                throw new ParseException("No user or group name in parameter " + formParameterName, 0);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException("Insufficient information in form parameter name: " + formParameterName, 0);
        }
        if ("user".equals(entityType)) {
            return new SpacePermission(permissionType, space, null, entityName);
        }
        if ("group".equals(entityType)) {
            return new SpacePermission(permissionType, space, entityName);
        }
        throw new ParseException("Unrecognised entity type: " + entityType + "in form parameter: " + formParameterName, 0);
    }

    public SpacePermission() {
    }

    public SpacePermission(String type) {
        this(type, null, null);
    }

    public SpacePermission(String type, Space space) {
        this(type, space, null);
    }

    public SpacePermission(String type, Space space, String group) {
        this(type, space, group, null);
    }

    public SpacePermission(String type, Space space, String group, String userName) {
        this.type = type;
        this.space = space;
        this.group = group;
        this.userName = userName;
    }

    public SpacePermission(SpacePermission spacePermission) {
        this.type = spacePermission.getType();
        this.space = spacePermission.getSpace();
        this.group = spacePermission.getGroup();
        this.userName = spacePermission.getUserName();
    }

    public Space getSpace() {
        return this.space;
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public long getSpaceId() {
        return this.getSpace().getId();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean isUserPermission() {
        return StringUtils.isNotBlank((String)this.userName);
    }

    public boolean isGroupPermission() {
        return StringUtils.isNotBlank((String)this.group);
    }

    public boolean isAnonymousPermission() {
        return !this.isUserPermission() && !this.isGroupPermission();
    }

    public boolean isGlobalPermission() {
        return !this.isSpacePermission();
    }

    public boolean isSpacePermission() {
        return this.getSpace() != null;
    }

    public String toString() {
        return "[" + this.getType() + "," + (this.getSpace() != null ? this.getSpace().getId() : 0L) + "," + this.getGroup() + "," + this.getUserName() + "]";
    }

    public boolean equals(Object obj) {
        SpacePermission perm;
        return obj instanceof SpacePermission && this.type.equals((perm = (SpacePermission)obj).getType()) && (this.space == null && perm.getSpace() == null || this.space != null && perm.getSpace() != null && this.space.getId() == perm.getSpace().getId()) && (this.group == null && perm.getGroup() == null || this.group != null && perm.getGroup() != null && this.group.equals(perm.getGroup())) && (this.userName == null && perm.getUserName() == null || this.userName != null && perm.getUserName() != null && this.userName.equals(perm.getUserName()));
    }

    public int hashCode() {
        int result = 29;
        result = 29 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 29 * result + (this.space != null ? (int)(this.space.getId() ^ this.space.getId() >>> 32) : 0);
        result = 29 * result + (this.group != null ? this.group.toLowerCase().hashCode() : 0);
        result = 29 * result + (this.userName != null ? this.userName.toLowerCase().hashCode() : 0);
        return result;
    }

    public static Collection getGenericSpacePermissions() {
        return GENERIC_SPACE_PERMISSIONS;
    }

    public static Collection getDefaultGlobalPermissions() {
        HashSet<SpacePermission> result = new HashSet<SpacePermission>();
        for (SpacePermission permission : DEFAULT_GLOBAL_PERMISSIONS) {
            result.add(new SpacePermission(permission));
        }
        return result;
    }

    public String toFormParameterName(String parameterType) {
        StringBuffer result = new StringBuffer(FULL_FORM_PARAMETER_PREFIX).append(parameterType).append(FORM_PARAMETER_SEPARATOR);
        result.append(this.getType().toLowerCase(Locale.ENGLISH)).append(FORM_PARAMETER_SEPARATOR);
        if (this.isUserPermission()) {
            result.append("user_").append(this.getUserName());
        } else if (this.isGroupPermission()) {
            result.append("group_").append(this.getGroup());
        } else if (this.isAnonymousPermission()) {
            result.append("anonymous");
        }
        return result.toString();
    }

    public boolean isAdministrativePermission() {
        return "SYSTEMADMINISTRATOR".equals(this.getType()) || CONFLUENCE_ADMINISTRATOR_PERMISSION.equals(this.getType()) || ADMINISTER_SPACE_PERMISSION.equals(this.getType());
    }

    public boolean isGuardPermission() {
        return USE_CONFLUENCE_PERMISSION.equals(this.getType()) || VIEWSPACE_PERMISSION.equals(this.getType());
    }

    public boolean isDependentOn(SpacePermission otherPermission) {
        boolean isSameSpacePermission;
        if (!otherPermission.isGuardPermission()) {
            return false;
        }
        if (this.isUserPermission() && !this.getUserName().equals(otherPermission.getUserName())) {
            return false;
        }
        if (this.isGroupPermission() && !this.getGroup().equals(otherPermission.getGroup())) {
            return false;
        }
        if (this.isGlobalPermission() && this.isAnonymousPermission()) {
            return otherPermission.isGlobalPermission() && otherPermission.isAnonymousPermission();
        }
        if (this.isGlobalPermission()) {
            return otherPermission.isGlobalPermission();
        }
        if (otherPermission.isGlobalPermission()) {
            return false;
        }
        boolean bl = isSameSpacePermission = this.getSpace().getId() == otherPermission.getSpace().getId();
        if (isSameSpacePermission && this.isAnonymousPermission()) {
            return otherPermission.isAnonymousPermission();
        }
        return isSameSpacePermission;
    }

    public boolean isInvalidAnonymousPermission() {
        return this.isAnonymousPermission() && INVALID_ANONYMOUS_PERMISSIONS.contains(this.getType());
    }

    static {
        ArrayList<String> permissionTypes = new ArrayList<String>();
        permissionTypes.add(USE_CONFLUENCE_PERMISSION);
        permissionTypes.add("SYSTEMADMINISTRATOR");
        permissionTypes.add(CONFLUENCE_ADMINISTRATOR_PERMISSION);
        permissionTypes.add(PERSONAL_SPACE_PERMISSION);
        permissionTypes.add(CREATE_SPACE_PERMISSION);
        permissionTypes.add(VIEWSPACE_PERMISSION);
        permissionTypes.add(COMMENT_PERMISSION);
        permissionTypes.add(CREATEEDIT_PAGE_PERMISSION);
        permissionTypes.add(ADMINISTER_SPACE_PERMISSION);
        permissionTypes.add(REMOVE_PAGE_PERMISSION);
        permissionTypes.add(REMOVE_COMMENT_PERMISSION);
        permissionTypes.add(REMOVE_BLOG_PERMISSION);
        permissionTypes.add(CREATE_ATTACHMENT_PERMISSION);
        permissionTypes.add(REMOVE_ATTACHMENT_PERMISSION);
        permissionTypes.add(EDITBLOG_PERMISSION);
        permissionTypes.add(EXPORT_PAGE_PERMISSION);
        permissionTypes.add(EXPORT_SPACE_PERMISSION);
        permissionTypes.add(REMOVE_MAIL_PERMISSION);
        permissionTypes.add(SET_PAGE_PERMISSIONS_PERMISSION);
        permissionTypes.add(PROFILE_ATTACHMENT_PERMISSION);
        PERMISSION_TYPES = Collections.unmodifiableList(permissionTypes);
        ArrayList<String> spacePermissions = new ArrayList<String>();
        spacePermissions.add(VIEWSPACE_PERMISSION);
        spacePermissions.add(COMMENT_PERMISSION);
        spacePermissions.add(CREATEEDIT_PAGE_PERMISSION);
        spacePermissions.add(ADMINISTER_SPACE_PERMISSION);
        spacePermissions.add(REMOVE_PAGE_PERMISSION);
        spacePermissions.add(REMOVE_COMMENT_PERMISSION);
        spacePermissions.add(REMOVE_BLOG_PERMISSION);
        spacePermissions.add(CREATE_ATTACHMENT_PERMISSION);
        spacePermissions.add(REMOVE_ATTACHMENT_PERMISSION);
        spacePermissions.add(EDITBLOG_PERMISSION);
        spacePermissions.add(EXPORT_PAGE_PERMISSION);
        spacePermissions.add(EXPORT_SPACE_PERMISSION);
        spacePermissions.add(REMOVE_MAIL_PERMISSION);
        spacePermissions.add(SET_PAGE_PERMISSIONS_PERMISSION);
        GENERIC_SPACE_PERMISSIONS = Collections.unmodifiableList(spacePermissions);
        ArrayList<String> globalPermissions = new ArrayList<String>();
        globalPermissions.add(USE_CONFLUENCE_PERMISSION);
        globalPermissions.add("SYSTEMADMINISTRATOR");
        globalPermissions.add(CONFLUENCE_ADMINISTRATOR_PERMISSION);
        globalPermissions.add(PERSONAL_SPACE_PERMISSION);
        globalPermissions.add(CREATE_SPACE_PERMISSION);
        globalPermissions.add(PROFILE_ATTACHMENT_PERMISSION);
        GLOBAL_PERMISSIONS = Collections.unmodifiableList(globalPermissions);
        ArrayList<String> invalidAnonymousPermissions = new ArrayList<String>();
        invalidAnonymousPermissions.add("SYSTEMADMINISTRATOR");
        invalidAnonymousPermissions.add(CONFLUENCE_ADMINISTRATOR_PERMISSION);
        invalidAnonymousPermissions.add(PERSONAL_SPACE_PERMISSION);
        invalidAnonymousPermissions.add(CREATE_SPACE_PERMISSION);
        invalidAnonymousPermissions.add(SET_PAGE_PERMISSIONS_PERMISSION);
        invalidAnonymousPermissions.add(ADMINISTER_SPACE_PERMISSION);
        INVALID_ANONYMOUS_PERMISSIONS = Collections.unmodifiableList(invalidAnonymousPermissions);
        ArrayList<SpacePermission> defaultPerms = new ArrayList<SpacePermission>();
        defaultPerms.add(new SpacePermission(USE_CONFLUENCE_PERMISSION, null, "confluence-users"));
        defaultPerms.add(new SpacePermission(USE_CONFLUENCE_PERMISSION, null, "confluence-administrators"));
        defaultPerms.add(new SpacePermission(PERSONAL_SPACE_PERMISSION, null, "confluence-users"));
        defaultPerms.add(new SpacePermission(PERSONAL_SPACE_PERMISSION, null, "confluence-administrators"));
        defaultPerms.add(new SpacePermission(CONFLUENCE_ADMINISTRATOR_PERMISSION, null, "confluence-administrators"));
        defaultPerms.add(new SpacePermission("SYSTEMADMINISTRATOR", null, "confluence-administrators"));
        defaultPerms.add(new SpacePermission(CREATE_SPACE_PERMISSION, null, "confluence-administrators"));
        DEFAULT_GLOBAL_PERMISSIONS = Collections.unmodifiableSet(new HashSet(defaultPerms));
    }
}

