/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.security.PermissionCheckDispatcherResultCache;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SpacePermissionCheckDispatcherCoordinator
implements SpacePermissionManager {
    private PermissionCheckDispatcherResultCache permissionCheckDispatcherResultCache;
    private SpacePermissionManager spacePermissionManager;

    public void savePermission(SpacePermission permission) {
        this.spacePermissionManager.savePermission(permission);
        this.refreshPermissionCheckDispatcherResultCacheIfNeeded(permission.getUserName(), permission.getGroup());
    }

    public void removeAllPermissions(Space space) {
        this.spacePermissionManager.removeAllPermissions(space);
    }

    public void removePermission(SpacePermission permission) {
        this.spacePermissionManager.removePermission(permission);
        this.refreshPermissionCheckDispatcherResultCacheIfNeeded(permission.getUserName(), permission.getGroup());
    }

    public boolean hasPermission(String permissionType, Space space, User remoteUser) {
        return this.spacePermissionManager.hasPermission(permissionType, space, remoteUser);
    }

    public boolean hasPermission(List permissionTypes, Space space, User remoteUser) {
        return this.spacePermissionManager.hasPermission(permissionTypes, space, remoteUser);
    }

    public void removeAllUserPermissions(String username) {
        this.spacePermissionManager.removeAllUserPermissions(username);
        this.refreshPermissionCheckDispatcherResultCacheIfNeeded(username, null);
    }

    public void removeAllPermissionsForGroup(String group) {
        this.spacePermissionManager.removeAllPermissionsForGroup(group);
        this.refreshPermissionCheckDispatcherResultCacheIfNeeded(null, group);
    }

    public List getAllPermissionsForGroup(String group) {
        return this.spacePermissionManager.getAllPermissionsForGroup(group);
    }

    public List getGlobalPermissions() {
        return this.spacePermissionManager.getGlobalPermissions();
    }

    public List getGlobalPermissions(String permissionType) {
        return this.spacePermissionManager.getGlobalPermissions(permissionType);
    }

    public void fixPermissions() {
        this.spacePermissionManager.fixPermissions();
    }

    public void flushCaches() {
        this.spacePermissionManager.flushCaches();
        this.permissionCheckDispatcherResultCache.flush();
    }

    public boolean groupHasPermission(String permissionType, Space space, String group) {
        return this.spacePermissionManager.groupHasPermission(permissionType, space, group);
    }

    public void createInitialSpacePermissions(Space space, User creator) {
        this.spacePermissionManager.createInitialSpacePermissions(space, creator);
    }

    public void createInitialSpacePermissions(Space space) {
        this.spacePermissionManager.createInitialSpacePermissions(space);
    }

    public boolean hasPermissionForSpace(User user, List permissionTypes, Space space) {
        return this.spacePermissionManager.hasPermissionForSpace(user, permissionTypes, space);
    }

    public Collection getGroupsWithPermissions(Space space) {
        return this.spacePermissionManager.getGroupsWithPermissions(space);
    }

    public Map getGroupsForPermissionType(String permissionType, Space space) {
        return this.spacePermissionManager.getGroupsForPermissionType(permissionType, space);
    }

    public Collection getUsersWithPermissions(Space space) {
        return this.spacePermissionManager.getUsersWithPermissions(space);
    }

    public Map getUsersForPermissionType(String permissionType, Space space) {
        return this.spacePermissionManager.getUsersForPermissionType(permissionType, space);
    }

    public boolean permissionExists(SpacePermission permission) {
        return this.spacePermissionManager.permissionExists(permission);
    }

    public void setPermissionCheckDispatcherResultCache(PermissionCheckDispatcherResultCache permissionCheckDispatcherResultCache) {
        this.permissionCheckDispatcherResultCache = permissionCheckDispatcherResultCache;
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    private void refreshPermissionCheckDispatcherResultCacheIfNeeded(String userName, String groupName) {
        String string = userName = userName == null && groupName == null ? "" : userName;
        if (userName != null) {
            this.permissionCheckDispatcherResultCache.removeFromCache(userName);
        } else if (groupName != null) {
            this.permissionCheckDispatcherResultCache.flush();
        }
    }
}

