/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.core.InsufficientPrivilegeException;
import com.atlassian.confluence.security.EntityRuntimeException;
import com.atlassian.confluence.security.InvalidOperationException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SetSpacePermissionChecker;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SpacePermissionCoordinator
implements SpacePermissionManager {
    private PermissionManager permissionManager;
    private UserManager userManager;
    private GroupManager groupManager;
    private SpacePermissionManager spacePermissionManager;
    private SetSpacePermissionChecker setSpacePermissionChecker;

    public void savePermission(SpacePermission permission) {
        if (!this.setSpacePermissionChecker.canSetPermission(AuthenticatedUserThreadLocal.getUser(), permission)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        this.spacePermissionManager.savePermission(permission);
    }

    public void removeAllPermissions(Space space) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.SET_PERMISSIONS, space)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        this.spacePermissionManager.removeAllPermissions(space);
    }

    public void removePermission(SpacePermission permission) {
        if (!this.setSpacePermissionChecker.canSetPermission(AuthenticatedUserThreadLocal.getUser(), permission)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        this.spacePermissionManager.removePermission(permission);
    }

    public void createInitialSpacePermissions(Space space, User creator) {
        this.spacePermissionManager.createInitialSpacePermissions(space, creator);
    }

    public void createInitialSpacePermissions(Space space) {
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (currentUser == null || !currentUser.getName().equals(space.getCreatorName()) && !this.permissionManager.hasPermission(currentUser, Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM)) {
            throw new InvalidOperationException("Must be the owner of the space or system administrator to create initial space permissions. User " + AuthenticatedUserThreadLocal.getUsername() + " tried to set permissions on space " + space.getKey() + " owned by " + space.getCreatorName());
        }
        this.spacePermissionManager.createInitialSpacePermissions(space);
    }

    public void removeAllUserPermissions(String username) {
        User user;
        try {
            user = this.userManager.getUser(username);
        }
        catch (EntityException e) {
            throw new EntityRuntimeException("Could not retrieve the user with username: " + username, e);
        }
        if (user == null) {
            throw new EntityRuntimeException("Could not retrieve the user with username: " + username);
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.SET_PERMISSIONS, user)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername(), "Failed to removed permissions of user with name: " + username);
        }
        this.spacePermissionManager.removeAllUserPermissions(username);
    }

    public void removeAllPermissionsForGroup(String groupName) {
        Group group;
        try {
            group = this.groupManager.getGroup(groupName);
        }
        catch (EntityException e) {
            throw new EntityRuntimeException("Could not retrieve the group with name: " + groupName, e);
        }
        if (group == null) {
            throw new EntityRuntimeException("Could not retrieve the group with name: " + groupName);
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.SET_PERMISSIONS, group)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername(), "Failed to remove permissions of group with name: " + groupName);
        }
        this.spacePermissionManager.removeAllPermissionsForGroup(groupName);
    }

    public boolean hasPermission(String permissionType, Space space, User remoteUser) {
        return this.spacePermissionManager.hasPermission(permissionType, space, remoteUser);
    }

    public boolean hasPermission(List permissionTypes, Space space, User remoteUser) {
        return this.spacePermissionManager.hasPermission(permissionTypes, space, remoteUser);
    }

    public List getAllPermissionsForGroup(String group) {
        return this.spacePermissionManager.getAllPermissionsForGroup(group);
    }

    public List getGlobalPermissions() {
        return this.spacePermissionManager.getGlobalPermissions();
    }

    public List getGlobalPermissions(String permissionType) {
        return this.spacePermissionManager.getGlobalPermissions(permissionType);
    }

    public void fixPermissions() {
        this.spacePermissionManager.fixPermissions();
    }

    public void flushCaches() {
        this.spacePermissionManager.flushCaches();
    }

    public boolean groupHasPermission(String permissionType, Space space, String group) {
        return this.spacePermissionManager.groupHasPermission(permissionType, space, group);
    }

    public boolean hasPermissionForSpace(User user, List permissionTypes, Space space) {
        return this.spacePermissionManager.hasPermissionForSpace(user, permissionTypes, space);
    }

    public Collection getGroupsWithPermissions(Space space) {
        return this.spacePermissionManager.getGroupsWithPermissions(space);
    }

    public Map getGroupsForPermissionType(String permissionType, Space space) {
        return this.spacePermissionManager.getGroupsForPermissionType(permissionType, space);
    }

    public Collection getUsersWithPermissions(Space space) {
        return this.spacePermissionManager.getUsersWithPermissions(space);
    }

    public Map getUsersForPermissionType(String permissionType, Space space) {
        return this.spacePermissionManager.getUsersForPermissionType(permissionType, space);
    }

    public boolean permissionExists(SpacePermission permission) {
        return this.spacePermissionManager.permissionExists(permission);
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public void setSetSpacePermissionChecker(SetSpacePermissionChecker setSpacePermissionChecker) {
        this.setSpacePermissionChecker = setSpacePermissionChecker;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }
}

