/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.spaces.actions.Spaced;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import org.apache.log4j.Logger;

public class PermissionCheckInterceptor
implements Interceptor {
    protected Logger log = Logger.getLogger(this.getClass());
    public static final String NOT_PERMITTED = "notpermitted";
    public static final String NOT_PERMITTED_PERSONAL_SPACE = "notpermittedpersonal";

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation actionInvocation) throws Exception {
        Action action = actionInvocation.getAction();
        if (action instanceof ConfluenceActionSupport) {
            ConfluenceActionSupport confluenceAction = (ConfluenceActionSupport)action;
            boolean permissionCheck = confluenceAction.isPermissionCheck();
            if (permissionCheck) {
                return confluenceAction.isPermittedAsString();
            }
            if (!confluenceAction.isPermitted()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Not permitted to execute action of class " + confluenceAction.getClass().getName()));
                }
                if (confluenceAction instanceof Spaced && ((Spaced)((Object)confluenceAction)).getSpace() != null && ((Spaced)((Object)confluenceAction)).getSpace().isPersonal()) {
                    return NOT_PERMITTED_PERSONAL_SPACE;
                }
                return NOT_PERMITTED;
            }
        }
        return actionInvocation.invoke();
    }
}

