/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.security.delegate.AbstractPermissionsDelegate;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;

public class ApplicationPermissionsDelegate
extends AbstractPermissionsDelegate {
    public boolean canView(User user, Object target) {
        return this.spacePermissionManager.hasPermission("USECONFLUENCE", null, user);
    }

    public boolean canEdit(User user, Object target) {
        throw new IllegalStateException("Edit permission does not apply on the application level.");
    }

    public boolean canSetPermissions(User user, Object target) {
        return this.spacePermissionManager.hasPermission("ADMINISTRATECONFLUENCE", null, user) || this.spacePermissionManager.hasPermission("SYSTEMADMINISTRATOR", null, user);
    }

    public boolean canRemove(User user, Object target) {
        throw new IllegalStateException("Remove permission does not apply on the application level.");
    }

    public boolean canExport(User user, Object target) {
        return this.spacePermissionManager.hasPermission("ADMINISTRATECONFLUENCE", null, user) || this.spacePermissionManager.hasPermission("SYSTEMADMINISTRATOR", null, user);
    }

    public boolean canAdminister(User user, Object target) {
        return this.spacePermissionManager.hasPermission("ADMINISTRATECONFLUENCE", null, user) || this.spacePermissionManager.hasPermission("SYSTEMADMINISTRATOR", null, user);
    }

    public boolean canCreate(User user, Object container) {
        throw new IllegalStateException("Create permission does not apply on the application level.");
    }

    protected Space getSpaceFrom(Object target) {
        return null;
    }
}

