/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.delegate.AbstractPermissionsDelegate;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;

public class BlogPostPermissionsDelegate
extends AbstractPermissionsDelegate {
    public boolean canView(User user, Object target) {
        return this.hasSpaceLevelPermission("VIEWSPACE", user, target);
    }

    public boolean canEdit(User user, Object target) {
        return this.hasSpaceLevelPermission("EDITBLOG", user, target);
    }

    public boolean canSetPermissions(User user, Object target) {
        throw new IllegalStateException("Permission-setting privileges do not apply to blog posts");
    }

    public boolean canRemove(User user, Object target) {
        return this.hasSpaceLevelPermission("REMOVEBLOG", user, target);
    }

    public boolean canExport(User user, Object target) {
        throw new IllegalStateException("Export privileges do not apply to blog posts");
    }

    public boolean canAdminister(User user, Object target) {
        throw new IllegalStateException("Administration privileges do not apply to blog posts");
    }

    protected Space getSpaceFrom(Object target) {
        return ((AbstractPage)target).getSpace();
    }

    public boolean canCreate(User user, Object container) {
        return this.spacePermissionManager.hasPermission("EDITBLOG", (Space)container, user);
    }
}

