/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.delegate.AbstractPermissionsDelegate;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import org.apache.commons.lang.StringUtils;

public class CommentPermissionsDelegate
extends AbstractPermissionsDelegate {
    private PermissionManager permissionManager;

    public boolean canView(User user, Object target) {
        return this.permissionManager.hasPermission(user, Permission.VIEW, ((Comment)target).getPage());
    }

    public boolean canEdit(User user, Object target) {
        if (user == null) {
            return false;
        }
        if (GeneralUtil.isSuperUser(user)) {
            return true;
        }
        Comment comment = (Comment)target;
        return this.canCreate(user, ((Comment)target).getPage()) && (StringUtils.equals((String)user.getName(), (String)comment.getCreatorName()) || this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target));
    }

    public boolean canSetPermissions(User user, Object target) {
        throw new IllegalStateException("Permission-setting privileges do not apply to comments");
    }

    public boolean canRemove(User user, Object target) {
        return this.hasSpaceLevelPermission("REMOVECOMMENT", user, target);
    }

    public boolean canExport(User user, Object target) {
        return this.permissionManager.hasPermission(user, Permission.EXPORT, ((Comment)target).getPage());
    }

    public boolean canAdminister(User user, Object target) {
        throw new IllegalStateException("Administration privileges do not apply to comments");
    }

    public void setPermissionManagerTarget(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public boolean canCreate(User user, Object container) {
        Space space;
        if (container instanceof AbstractPage) {
            space = ((AbstractPage)container).getSpace();
        } else if (container instanceof Space) {
            space = (Space)container;
        } else {
            throw new IllegalArgumentException("Unsupported container for create comment permission check: " + container.getClass());
        }
        return this.spacePermissionManager.hasPermission("COMMENT", space, user);
    }

    protected Space getSpaceFrom(Object target) {
        return ((Comment)target).getPage().getSpace();
    }
}

