/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.security.delegate.AbstractPermissionsDelegate;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;

public class DraftPermissionsDelegate
extends AbstractPermissionsDelegate {
    public boolean canView(User user, Object target) {
        return this.isAuthor(user, target);
    }

    public boolean canEdit(User user, Object target) {
        return this.isAuthor(user, target);
    }

    public boolean canSetPermissions(User user, Object target) {
        return this.isAuthor(user, target);
    }

    public boolean canRemove(User user, Object target) {
        return this.isAuthor(user, target);
    }

    public boolean canExport(User user, Object target) {
        throw new IllegalStateException("Drafts should not be exported.");
    }

    public boolean canAdminister(User user, Object target) {
        throw new IllegalStateException("Administration privileges do not apply to drafts");
    }

    public boolean canCreate(User user, Object container) {
        return this.hasSpaceLevelPermission("EDITSPACE", user, container);
    }

    private boolean isAuthor(User user, Object target) {
        Draft draft = (Draft)target;
        return draft.getCreatorName() != null && draft.getCreatorName().equals(user.getName());
    }

    protected Space getSpaceFrom(Object target) {
        assert (target instanceof Space);
        return (Space)target;
    }
}

