/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.security.PermissionDelegate;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.user.Group;
import com.atlassian.user.User;

public class GroupPermissionsDelegate
implements PermissionDelegate {
    private SpacePermissionManager spacePermissionManager;

    public boolean canView(User user, Object target) {
        return true;
    }

    public boolean canEdit(User user, Object group) {
        return this.hasRelevantAdministrativePermission(user, (Group)group);
    }

    public boolean canRemove(User user, Object target) {
        return this.hasRelevantAdministrativePermission(user, (Group)target);
    }

    public boolean canCreate(User user, Object container) {
        return this.spacePermissionManager.hasPermission("ADMINISTRATECONFLUENCE", null, user) || this.spacePermissionManager.hasPermission("SYSTEMADMINISTRATOR", null, user);
    }

    public boolean canExport(User user, Object target) {
        throw new UnsupportedOperationException("Export privileges is undefined for groups and hence does not apply.");
    }

    public boolean canSetPermissions(User user, Object target) {
        return this.hasRelevantAdministrativePermission(user, (Group)target);
    }

    private boolean hasRelevantAdministrativePermission(User user, Group targetGroup) {
        if (this.spacePermissionManager.groupHasPermission("SYSTEMADMINISTRATOR", null, targetGroup.getName()) || "confluence-administrators".equals(targetGroup.getName())) {
            return this.spacePermissionManager.hasPermission("SYSTEMADMINISTRATOR", null, user);
        }
        return true;
    }

    public boolean canAdminister(User user, Object target) {
        throw new UnsupportedOperationException("Administer privileges is undefined for groups and hence does not apply.");
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }
}

