/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.links.AbstractLink;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionDelegate;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.user.User;

public class LinkPermissionsDelegate
implements PermissionDelegate {
    private PermissionManager permissionManager;

    public boolean canView(User user, Object target) {
        return this.permissionManager.hasPermission(user, Permission.VIEW, this.getContent(target));
    }

    public boolean canEdit(User user, Object target) {
        throw new IllegalStateException("Links do not support edit permissions");
    }

    public boolean canSetPermissions(User user, Object target) {
        throw new IllegalStateException("Links do not support permission-setting permissions");
    }

    public boolean canRemove(User user, Object target) {
        throw new IllegalStateException("Links do not support remove permissions");
    }

    public boolean canExport(User user, Object target) {
        throw new IllegalStateException("Links do not support export permissions");
    }

    public boolean canAdminister(User user, Object target) {
        throw new IllegalStateException("Links do not support administer permissions");
    }

    public boolean canCreate(User user, Object container) {
        throw new IllegalStateException("Links do not support create permissions");
    }

    public void setPermissionManagerTarget(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    private Object getContent(Object target) {
        return ((AbstractLink)target).getSourceContent();
    }
}

