/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.security.delegate.AbstractPermissionsDelegate;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;

public class MailPermissionsDelegate
extends AbstractPermissionsDelegate {
    public boolean canView(User user, Object target) {
        return this.hasSpaceLevelPermission("VIEWSPACE", user, target);
    }

    public boolean canEdit(User user, Object target) {
        throw new IllegalStateException("Editing privileges do not apply to mail");
    }

    public boolean canSetPermissions(User user, Object target) {
        throw new IllegalStateException("Permission-setting privileges do not apply to mail");
    }

    public boolean canRemove(User user, Object target) {
        return this.hasSpaceLevelPermission("REMOVEMAIL", user, target);
    }

    public boolean canExport(User user, Object target) {
        throw new IllegalStateException("Export privileges do not apply to mail");
    }

    public boolean canAdminister(User user, Object target) {
        throw new IllegalStateException("Administration privileges do not apply to mail");
    }

    public boolean canCreate(User user, Object container) {
        return this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", (Space)container, user);
    }

    protected Space getSpaceFrom(Object target) {
        return ((Mail)target).getSpace();
    }
}

