/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.persistence.dao.hibernate;

import com.atlassian.confluence.security.persistence.dao.hibernate.KeyTransferBean;
import com.atlassian.hibernate.BucketClobStringType;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CryptographicKeyType
extends BucketClobStringType {
    private static final int OFFSET_TYPE = 0;
    private static final int OFFSET_ALGORITHM = 1;
    private static final int OFFSET_KEYSPEC = 2;

    public Class returnedClass() {
        return Key.class;
    }

    public int[] sqlTypes() {
        int[] types = new int[]{12, 12, super.sqlTypes()[0]};
        return types;
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, Object owner) throws SQLException {
        String encodedKey = (String)super.nullSafeGet(resultSet, new String[]{names[2]}, owner);
        String typeString = resultSet.getString(names[0]);
        KeyTransferBean bean = new KeyTransferBean(typeString, resultSet.getString(names[1]), encodedKey);
        return bean.asKey();
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object o, int i) throws SQLException {
        if (!(o instanceof PrivateKey) && !(o instanceof PublicKey)) {
            throw new IllegalArgumentException("Object is not an instance of java.security.{PublicKey,PrivateKey}");
        }
        Key key = (Key)o;
        KeyTransferBean bean = new KeyTransferBean(key);
        preparedStatement.setString(i + 0, bean.getKeyType());
        preparedStatement.setString(i + 1, key.getAlgorithm());
        super.nullSafeSet(preparedStatement, (Object)bean.getEncodedKey(), i + 2);
    }
}

