/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.persistence.dao.hibernate;

import com.atlassian.confluence.core.persistence.hibernate.VersionedHibernateObjectDao;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.persistence.dao.SpacePermissionDao;
import com.atlassian.confluence.spaces.Space;
import java.util.List;
import net.sf.hibernate.type.StringType;
import net.sf.hibernate.type.Type;

public class HibernateSpacePermissionDao
extends VersionedHibernateObjectDao
implements SpacePermissionDao {
    private static final String GET_PERMISSIONS = "select permission from SpacePermission as permission";

    public Class getPersistentClass() {
        return SpacePermission.class;
    }

    public SpacePermission getById(long id) {
        return (SpacePermission)this.getByClassId(id);
    }

    public boolean hasPermission(SpacePermission permission) {
        StringBuffer hql = new StringBuffer(128);
        hql.append("select count(sp) from SpacePermission sp ");
        if (permission.getSpace() == null) {
            hql.append("where sp.space is null ");
        } else {
            hql.append("where sp.space.id = :spaceId ");
        }
        if (permission.getGroup() == null) {
            hql.append("and sp.group is null ");
        } else {
            hql.append("and sp.group = :group ");
        }
        if (permission.getUserName() == null) {
            hql.append("and sp.userName is null ");
        } else {
            hql.append("and sp.userName = :userName ");
        }
        if (permission.getType() == null) {
            hql.append("and sp.type is null ");
        } else {
            hql.append("and sp.type = :type ");
        }
        List allResults = this.getHibernateTemplate().findByValueBean(hql.toString(), (Object)permission);
        return ((Number)allResults.get(0)).intValue() > 0;
    }

    public List findAllGlobalPermissions() {
        return this.findNamedQuery("confluence.sp_findAllGlobalPermissions");
    }

    public List findAllGlobalPermissionsForType(String permissionType) {
        return this.getHibernateTemplate().findByNamedQueryAndNamedParam("confluence.sp_findAllGlobalPermissionsForType", "type", (Object)permissionType);
    }

    public List findPermissionsForGroup(String group) {
        return this.getHibernateTemplate().findByNamedQueryAndNamedParam("confluence.sp_findPermissionsForGroup", "group", (Object)group);
    }

    public List findPermissionsForSpace(Space space) {
        return this.getHibernateTemplate().findByNamedQueryAndNamedParam("confluence.sp_findPermissionsForSpace", "spaceid", (Object)new Long(space.getId()));
    }

    public List findPermissionsForUser(String userName) {
        return this.getHibernateTemplate().findByNamedQueryAndNamedParam("confluence.sp_findPermissionsForUser", "userName", (Object)userName);
    }

    public void removePermissionsForUser(String userName) {
        this.getHibernateTemplate().delete("select permission from SpacePermission as permission where permission.userName = ?", (Object)userName, (Type)new StringType());
    }

    public void removePermissionsForGroup(String group) {
        this.getHibernateTemplate().delete("select permission from SpacePermission as permission where permission.group = ?", (Object)group, (Type)new StringType());
    }

    public void removePermissionsForSpace(Space space) {
        this.getHibernateTemplate().delete("select permission from SpacePermission as permission where SPACEID = " + space.getId());
    }

    public List findPermissionTypes(SpacePermission permission) {
        StringBuffer hql = new StringBuffer();
        hql.append("from SpacePermission sp ");
        if (permission.getSpace() == null) {
            hql.append("where sp.space is null ");
        } else {
            hql.append("where sp.space.id = :spaceId ");
        }
        if (permission.getGroup() == null) {
            hql.append("and sp.group is null ");
        } else {
            hql.append("and sp.group = :group ");
        }
        if (permission.getUserName() == null) {
            hql.append("and sp.userName is null ");
        } else {
            hql.append("and sp.userName = :userName ");
        }
        return this.getHibernateTemplate().findByValueBean(hql.toString(), (Object)permission);
    }
}

