/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.servlet.ServletManager;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;

public class SpringManagedServlet
extends HttpServlet {
    public static final String COMPONENT_NAME_KEY = "springComponentName";
    public static final Category log = Category.getInstance(SpringManagedServlet.class);
    private ServletManager servletManager;
    private ServletConfig servletConfig;
    private String componentName;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletConfig = servletConfig;
        this.componentName = servletConfig.getInitParameter(COMPONENT_NAME_KEY);
        if (!TextUtils.stringSet((String)this.componentName)) {
            throw new ServletException(this.getServletName() + " missing a " + COMPONENT_NAME_KEY + " servlet parameter");
        }
    }

    public void destroy() {
        if (this.servletManager != null) {
            try {
                this.servletManager.servletDestroyed(this);
            }
            catch (Exception e) {
                log.error((Object)("Error destroying servlet: " + e), (Throwable)e);
            }
        }
        super.destroy();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.getServletManager() == null) {
            throw new ServletException("Confluence is not yet configured to service this request");
        }
        this.getServletManager().service(this, request, response);
    }

    private synchronized ServletManager getServletManager() throws ServletException {
        if (this.servletManager == null && BootstrapUtils.getBootstrapManager().isSetupComplete()) {
            try {
                this.servletManager = (ServletManager)ContainerManager.getComponent((String)this.componentName);
                if (this.servletManager == null) {
                    log.error((Object)(this.getServletName() + " unable to load servlet manager. Could not find component with name: " + this.componentName));
                } else {
                    this.servletManager.servletInitialised(this, this.servletConfig);
                }
            }
            catch (ClassCastException e) {
                log.error((Object)(this.getServletName() + " unable to load servlet manager. Component with name " + this.componentName + " is wrong class: " + ContainerManager.getComponent((String)this.componentName).getClass().getName()));
            }
        }
        return this.servletManager;
    }
}

