/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet.download;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.util.GeneralUtil;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AttachmentUrlParser {
    private ContentEntityObjectDao contentEntityObjectDao;
    private AttachmentManager attachmentManager;

    public Attachment getAttachment(String urlPath, String urlPrefix, Map parameters) {
        ContentEntityObject entity = this.getEntity(urlPath, urlPrefix);
        String fileName = this.getAttachmentFileName(urlPath);
        int version = this.getIntParameter("version", parameters);
        return this.attachmentManager.getAttachment(entity, fileName, version);
    }

    public ContentEntityObject getEntity(String urlPath, String prefix) {
        long entityId = this.getEntityId(urlPath, prefix);
        if (entityId == -1L) {
            return null;
        }
        return this.contentEntityObjectDao.getById(entityId);
    }

    public long getEntityId(String urlPath, String prefix) {
        String[] parts = urlPath.split("/");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (!part.equals(prefix) || i + 1 >= parts.length) continue;
            try {
                return Long.parseLong(parts[i + 1]);
            }
            catch (NumberFormatException ex) {
                return -1L;
            }
        }
        return -1L;
    }

    public String getAttachmentFileName(String urlPath) {
        return urlPath.substring(urlPath.lastIndexOf(47) + 1);
    }

    public void setContentEntityObjectDao(ContentEntityObjectDao contentEntityObjectDao) {
        this.contentEntityObjectDao = contentEntityObjectDao;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    private int getIntParameter(String parameterName, Map parameters) {
        Object obj = parameters.get(parameterName);
        if (obj != null) {
            Integer integerValue;
            String stringValue = obj.toString();
            if (obj instanceof String[]) {
                String[] values = (String[])obj;
                for (int i = 0; i < values.length; ++i) {
                    if (!StringUtils.isNotEmpty((String)values[i])) continue;
                    stringValue = values[i];
                    break;
                }
            }
            if ((integerValue = GeneralUtil.convertToInteger(stringValue)) == null) {
                throw new RuntimeException(parameterName + " '" + obj + "' is not a valid number");
            }
            return integerValue;
        }
        return 0;
    }
}

