/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet.download;

import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.plugin.servlet.BaseFileServerServlet;
import com.atlassian.plugin.servlet.DownloadStrategy;
import com.atlassian.plugin.servlet.ResourceDownloadUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class ServeAfterTransactionDownload
implements DownloadStrategy {
    private PlatformTransactionManager transactionManager;

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public static String getDecodedPathInfo(HttpServletRequest httpServletRequest) {
        return GeneralUtil.urlDecode(httpServletRequest.getPathInfo());
    }

    private InputStream getStreamInTransaction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        TransactionTemplate tt = new TransactionTemplate(this.transactionManager);
        StreamResult result = (StreamResult)tt.execute(this.getStreamResultCallback(httpServletRequest, httpServletResponse));
        return result.getStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serveFile(BaseFileServerServlet baseFileServerServlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        InputStream is = this.getStreamInTransaction(httpServletRequest, httpServletResponse);
        if (is == null) {
            return;
        }
        try {
            ResourceDownloadUtils.serveFileImpl((HttpServletResponse)httpServletResponse, (InputStream)is);
        }
        finally {
            IOUtils.close(is);
        }
    }

    protected TransactionCallback getStreamResultCallback(HttpServletRequest request, HttpServletResponse response) {
        return new StreamResultCallback(request, response);
    }

    protected abstract InputStream getStreamForDownload(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    protected class StreamResultCallback
    implements TransactionCallback {
        private final HttpServletRequest request;
        private final HttpServletResponse response;

        public StreamResultCallback(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object doInTransaction(TransactionStatus transactionStatus) {
            InputStream is = null;
            IOException exception = null;
            try {
                is = ServeAfterTransactionDownload.this.getStreamForDownload(this.request, this.response);
            }
            catch (IOException ex) {
                exception = ex;
            }
            return new StreamResult(is, exception);
        }
    }

    private static class StreamResult {
        private final IOException exception;
        private final InputStream stream;

        public StreamResult(InputStream stream, IOException exception) {
            this.exception = exception;
            this.stream = stream;
        }

        public InputStream getStream() throws IOException {
            if (this.exception != null) {
                IOException deferredException = new IOException("An exception was encountered while getting a stream");
                deferredException.initCause(this.exception);
                throw deferredException;
            }
            return this.stream;
        }
    }
}

