/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet.simpledisplay;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.servlet.ServletManager;
import com.atlassian.confluence.servlet.SpringManagedServlet;
import com.atlassian.confluence.servlet.simpledisplay.ConvertedPath;
import com.atlassian.confluence.servlet.simpledisplay.PathConverter;
import com.atlassian.confluence.servlet.simpledisplay.PathConverterManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.xwork.interceptors.RequestParameterHackInterceptor;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.net.SocketException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SimpleDisplayServlet
implements ServletManager {
    private Logger log = Logger.getLogger(SimpleDisplayServlet.class);
    protected static final String HOMEPAGE_PATH = "/homepage.action";
    private PathConverterManager pathConverterManager;

    public void servletDestroyed(SpringManagedServlet springManagedServlet) {
    }

    public void servletInitialised(SpringManagedServlet springManagedServlet, ServletConfig servletConfig) throws ServletException {
    }

    public void service(SpringManagedServlet springManagedServlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (!BootstrapUtils.getBootstrapManager().isSetupComplete()) {
            httpServletResponse.sendError(503);
            return;
        }
        String pathInfo = GeneralUtil.urlDecode(httpServletRequest.getPathInfo());
        try {
            String pathToForward = this.parsePath(pathInfo);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Forwarding the request to '" + pathToForward + "'..."));
            }
            httpServletRequest.getRequestDispatcher(pathToForward).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (SocketException e) {
            this.log.debug((Object)("Client closed socket: " + e.getMessage()), (Throwable)e);
        }
        catch (ParseException e) {
            this.log.debug((Object)("Failed to parse path " + pathInfo), (Throwable)e);
            httpServletResponse.sendError(404, "Page not found: " + pathInfo);
        }
        catch (Exception e) {
            this.log.warn((Object)("Error while parsing path " + pathInfo), (Throwable)e);
            httpServletResponse.sendError(404, "Page not found: " + pathInfo);
        }
    }

    private String parsePath(String pathInfo) throws ParseException {
        if (!TextUtils.stringSet((String)(pathInfo = SimpleDisplayServlet.stripSlashes(pathInfo)))) {
            return HOMEPAGE_PATH;
        }
        List pathConverters = this.getPathConverterManager().getPathConverters();
        for (PathConverter pathConverter : pathConverters) {
            if (!pathConverter.handles(pathInfo)) continue;
            ConvertedPath convertedPath = pathConverter.getPath(pathInfo);
            RequestParameterHackInterceptor.setHackMap((Map)convertedPath.getParameters());
            String result = convertedPath.getPath();
            if (!TextUtils.stringSet((String)result)) continue;
            return result;
        }
        throw new ParseException("Simple path: " + pathInfo + " could not be translated", 0);
    }

    public static String stripSlashes(String path) {
        if (!TextUtils.stringSet((String)path)) {
            return "";
        }
        String result = path;
        while (result.startsWith("/")) {
            result = result.substring(1);
        }
        while (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public PathConverterManager getPathConverterManager() {
        return this.pathConverterManager;
    }

    public void setPathConverterManager(PathConverterManager pathConverterManager) {
        this.pathConverterManager = pathConverterManager;
    }
}

