/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet.simpledisplay;

import com.atlassian.confluence.servlet.simpledisplay.ConvertedPath;
import com.atlassian.confluence.servlet.simpledisplay.PathConverter;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.opensymphony.util.TextUtils;
import java.util.regex.Pattern;

public class SpacePathConverter
implements PathConverter {
    public static final String DISPLAY_SPACE_HOME_PAGE_PATH = "/spaces/viewspace.action?key=${key}";
    private static final String DISPLAY_SPACE_SUMMARY_PATH = "/spaces/browsespace.action?key=${key}";
    private SettingsManager settingsManager;

    public boolean handles(String simplePath) {
        Pattern pattern = Pattern.compile("^/?[\\p{Alnum}]*/?$");
        return pattern.matcher(simplePath).matches();
    }

    public ConvertedPath getPath(String simplePath) {
        String spaceKey = simplePath;
        if (TextUtils.stringSet((String)simplePath) && simplePath.endsWith("/")) {
            spaceKey = simplePath.substring(0, simplePath.length() - 1);
        }
        String spacePath = this.settingsManager.getGlobalSettings().isViewSpaceGoesToSpaceSummary() ? DISPLAY_SPACE_SUMMARY_PATH : DISPLAY_SPACE_HOME_PAGE_PATH;
        ConvertedPath convertedPath = new ConvertedPath(spacePath);
        convertedPath.addParameter("key", spaceKey);
        return convertedPath;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }
}

