/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup;

import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.setup.BootstrapContextInitialisedEvent;
import com.atlassian.confluence.setup.ConfluenceClassPathXmlApplicationContext;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.johnson.event.Event;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class ConfluenceConfigurationListener
implements ServletContextListener {
    private static final Logger log = Logger.getLogger(ConfluenceConfigurationListener.class);
    private static final Logger startupLog = Logger.getLogger((String)"com.atlassian.confluence.lifecycle");

    public void contextInitialized(ServletContextEvent event) {
        try {
            GeneralUtil.loadDefaultProperties();
            this.setStartupTime(event.getServletContext());
            startupLog.info((Object)("Starting Confluence " + GeneralUtil.getVersionNumber() + " (build #" + GeneralUtil.getBuildNumber() + ")"));
            this.initialiseBootstrapContext(event);
            this.doStartupPropertyChecks();
        }
        catch (Exception e) {
            JohnsonEventContainer agentJohnson = JohnsonEventContainer.get((ServletContext)event.getServletContext());
            JohnsonConfig johnsonConfig = JohnsonConfig.getInstance();
            agentJohnson.addEvent(new Event(johnsonConfig.getEventType("bootstrap"), "Could not load bootstrap from environment", e.toString(), johnsonConfig.getEventLevel("fatal")));
            log.fatal((Object)("An error was encountered while bootstrapping Confluence (see below): \n" + e.getMessage()), (Throwable)e);
        }
    }

    private void doStartupPropertyChecks() {
        if (LogManager.getRootLogger().getLevel().equals((Object)Level.DEBUG) && !"true".equals(System.getProperty("confluence.ignore.debug.logging"))) {
            startupLog.error((Object)"***************************************************************************************************************");
            startupLog.error((Object)"The root log4j logger is set to DEBUG level. This may cause Confluence to run slowly.");
            startupLog.error((Object)"If you are running Confluence under JBoss, please read http://confluence.atlassian.com/x/PtAB");
            startupLog.error((Object)"To disable this error message, start your appserver with the system property -Dconfluence.ignore.debug.logging=true");
            startupLog.error((Object)"***************************************************************************************************************");
        }
        if (Boolean.getBoolean("confluence.devmode")) {
            startupLog.info((Object)"Confluence is starting in DevMode. Developer/debugging options will be enabled");
        }
        if (Boolean.getBoolean("com.atlassian.confluence.donotsuck")) {
            startupLog.info((Object)"Do not suck flag enabled. Starting Confluence in negative suckage mode.");
        }
    }

    private void initialiseBootstrapContext(ServletContextEvent event) throws BootstrapException {
        ConfluenceClassPathXmlApplicationContext bootstrapContext = new ConfluenceClassPathXmlApplicationContext(new String[]{"bootstrapContext.xml", "setupContext.xml"});
        BootstrapUtils.init((ApplicationContext)bootstrapContext, (ServletContext)event.getServletContext());
        BootstrapUtils.getBootstrapContext().publishEvent((ApplicationEvent)new BootstrapContextInitialisedEvent(this));
    }

    public void contextDestroyed(ServletContextEvent event) {
        startupLog.info((Object)"Stopping Confluence");
        BootstrapUtils.closeContext();
    }

    private void setStartupTime(ServletContext context) {
        Long currentTime = new Long(System.currentTimeMillis());
        if (context != null) {
            context.setAttribute("confluence_startup_time", (Object)currentTime);
        }
        GeneralUtil.setSystemStartupTime(currentTime);
    }
}

