/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.setup.SetupException;
import com.atlassian.config.wizard.DefaultSetupStep;
import com.atlassian.confluence.jmx.JmxSMTPMailServer;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.SMTPMailServer;
import java.util.List;

public class ConfluenceEmailSetup
extends DefaultSetupStep {
    public ConfluenceEmailSetup(String name, String actionName) {
        super(name, actionName);
    }

    public void addStandardEmail(String name, String description, String from, String prefix, String host, String userName, String password) throws ConfigurationException {
        this.addEmail(name, description, from, prefix, false, host, userName, password);
    }

    public void addJndiEmail(String name, String description, String from, String prefix, String jndiLocation, String userName, String password) throws ConfigurationException {
        this.addEmail(name, description, from, prefix, true, jndiLocation, userName, password);
    }

    private synchronized void addEmail(String name, String description, String from, String prefix, boolean isSession, String location, String userName, String password) throws ConfigurationException {
        try {
            this.removeAllExistingServers();
            JmxSMTPMailServer mailServer = new JmxSMTPMailServer(null, name, description, from, prefix, isSession, location, userName, password);
            MailFactory.getServerManager().create((MailServer)mailServer);
        }
        catch (MailException e) {
            throw new ConfigurationException("Adding email server failed", (Throwable)e);
        }
    }

    private void removeAllExistingServers() throws MailException {
        List servers = MailFactory.getServerManager().getSmtpMailServers();
        for (int i = 0; i < servers.size(); ++i) {
            SMTPMailServer server = (SMTPMailServer)servers.get(i);
            MailFactory.getServerManager().delete(server.getId());
        }
    }

    public synchronized SMTPMailServer getEmailServer() throws SetupException {
        try {
            return MailFactory.getServerManager().getDefaultSMTPMailServer();
        }
        catch (MailException e) {
            throw new SetupException("Adding email server failed", (Throwable)e);
        }
    }
}

