/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.bootstrap.DefaultAtlassianBootstrapManager;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.config.db.DatabaseHelper;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.cluster.ClusterConfigurationHelper;
import com.atlassian.confluence.cluster.ClusterException;
import com.atlassian.confluence.event.events.admin.ConfluenceReadyEvent;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.ConfluenceLicenseRegistry;
import com.atlassian.confluence.setup.SharedConfigurationMap;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.hibernate.dialect.DB2Dialect;
import com.atlassian.hibernate.dialect.MySQLDialect;
import com.atlassian.license.LicenseManager;
import com.atlassian.license.LicenseRegistry;
import com.atlassian.license.LicenseTypeStore;
import com.atlassian.license.applications.confluence.ConfluenceLicenseTypeStore;
import com.atlassian.spring.container.ContainerContext;
import com.atlassian.spring.container.ContainerManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DefaultBootstrapManager
extends DefaultAtlassianBootstrapManager
implements BootstrapManager {
    private DatabaseHelper databaseHelper;
    private ClusterConfigurationHelper clusterConfigurationHelper;
    private static Map databaseDialectConversions = new HashMap();

    public void publishConfiguration() {
        if (this.clusterConfigurationHelper.isClusteredInstance()) {
            this.clusterConfigurationHelper.publishConfiguration();
        }
    }

    public String getFilePathProperty(String key) {
        String path = this.getString(key);
        String confHome = this.getConfluenceHome();
        return GeneralUtil.replaceConfluenceHomeConstant(path, confHome);
    }

    protected String getDbUrl(DatabaseDetails dbDetails) {
        String confHome = this.getConfluenceHome();
        return GeneralUtil.replaceConfluenceHomeConstant(super.getDbUrl(dbDetails), confHome);
    }

    public String getConfluenceHome() {
        String confHome = this.applicationConfig.getApplicationHome();
        if (confHome == null) {
            log.fatal((Object)"${confluenceHome} has not been configured or is returning a null. Please check your confluence home configuration.");
        }
        return confHome;
    }

    public void setConfluenceHome(String confluenceHome) throws ConfigurationException {
        this.applicationConfig.setApplicationHome(confluenceHome);
    }

    public boolean isConfluenceHomeValid() {
        return this.isApplicationHomeValid();
    }

    public String getBaseUrl() {
        return GeneralUtil.getGlobalSettings().getBaseUrl();
    }

    public String getDomainName() {
        return this.getBaseUrl();
    }

    public void setBaseUrl(String baseUrl) {
        SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        if (settingsManager == null) {
            throw new IllegalStateException("SettingsManager not available at this point");
        }
        Settings globalSettings = settingsManager.getGlobalSettings();
        globalSettings.setBaseUrl(baseUrl);
        settingsManager.updateGlobalSettings(globalSettings);
    }

    public boolean isWebdavEnabled() {
        return GeneralUtil.getGlobalSettings().isWebdavEnabled();
    }

    public void bootstrapSharedConfiguration(SharedConfigurationMap sharedConfig) throws BootstrapException {
        try {
            for (String key : sharedConfig.keySet()) {
                this.setProperty(key, sharedConfig.get((Serializable)((Object)key)));
            }
            BootstrapUtils.getBootstrapManager().save();
            ContainerContext ctx = ContainerManager.getInstance().getContainerContext();
            ctx.refresh();
            BootstrapUtils.getBootstrapManager().setProperty("hibernate.setup", (Object)"true");
            EventManager eventManager = (EventManager)ctx.getComponent((Object)"eventManager");
            eventManager.publishEvent((Event)new ConfluenceReadyEvent(this));
        }
        catch (ConfigurationException ce) {
            log.fatal((Object)"Could not successfully configure db from shared configuration.");
            log.fatal((Object)("ConfigurationException reads thus: " + (Object)((Object)ce)), (Throwable)ce);
            this.hibernateConfigurator.unconfigureDatabase();
            throw new BootstrapException((Throwable)ce);
        }
    }

    public String getConfiguredConfluenceHome() {
        return this.getConfiguredApplicationHome();
    }

    protected boolean performPersistenceUpgrade() {
        return this.upgradeHSQL() && this.updateDatabaseDialects();
    }

    private boolean updateDatabaseDialects() {
        String currrentDatabaseDialect = (String)this.applicationConfig.getProperty((Object)"hibernate.dialect");
        if (databaseDialectConversions.containsKey(currrentDatabaseDialect)) {
            return this.updateDatabaseDialect((String)databaseDialectConversions.get(currrentDatabaseDialect));
        }
        return true;
    }

    private boolean updateDatabaseDialect(String newDialect) {
        try {
            this.applicationConfig.setProperty((Object)"hibernate.dialect", (Object)newDialect);
            this.applicationConfig.save();
            return true;
        }
        catch (ConfigurationException e) {
            log.error((Object)("Error updating the database dialect: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private boolean upgradeHSQL() {
        if ("net.sf.hibernate.dialect.HSQLDialect".equals(this.applicationConfig.getProperty((Object)"hibernate.dialect"))) {
            double currentVersion;
            String propertiesPath;
            Properties p;
            try {
                p = new Properties();
                propertiesPath = this.homeLocator.getHomePath() + "/database/confluencedb.properties";
                p.load(new FileInputStream(new File(propertiesPath)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                String versionString = p.getProperty("version");
                versionString = versionString.substring(0, versionString.indexOf(46) + 2);
                currentVersion = Double.parseDouble(versionString);
            }
            catch (Exception e) {
                throw new RuntimeException("The version property in " + propertiesPath + " is badly formed or missing. It should be a decimal style value such as 1.7");
            }
            try {
                if (currentVersion < 1.8) {
                    String line;
                    File inputFile = new File(this.homeLocator.getHomePath() + "/database/confluencedb.script");
                    File outputFile = File.createTempFile("conf", ".tmp");
                    BufferedReader reader = new BufferedReader(new FileReader(inputFile));
                    BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
                    while ((line = reader.readLine()) != null) {
                        if (line.toUpperCase().startsWith("CREATE ALIAS SUBSTRING") || line.toUpperCase().startsWith("CREATE ALIAS CONCAT")) continue;
                        if (line.toUpperCase().startsWith("CREATE TABLE ANCESTORS") || line.toUpperCase().startsWith("CREATE TABLE CONFANCESTORS")) {
                            line = line.replaceAll("([^R])POSITION", "$1ANCESTORPOSITION");
                        }
                        writer.write(line);
                        writer.write("\n");
                    }
                    ((Writer)writer).close();
                    reader.close();
                    inputFile.delete();
                    outputFile.renameTo(inputFile);
                    Class<?> driverClass = Class.forName("org.hsqldb.jdbcDriver");
                    DriverManager.registerDriver((Driver)driverClass.newInstance());
                    try {
                        Connection c = DriverManager.getConnection((String)this.applicationConfig.getProperty((Object)"hibernate.connection.url"), (String)this.applicationConfig.getProperty((Object)"hibernate.connection.username"), (String)this.applicationConfig.getProperty((Object)"hibernate.connection.password"));
                        c.close();
                        return true;
                    }
                    catch (SQLException sqle) {
                        String message = "HSQL Database needs to be cleaned. Please run HSQL17To18PreUpgradeCleaner. See http://confluence.atlassian.com/display/DOC/Upgrading+From+HSQL+1.7.1+to+1.8";
                        log.error((Object)message);
                        log.error((Object)("SQL Error Message: " + sqle.getMessage()));
                        this.bootstrapped = false;
                        this.bootstrapFailureReason = message + " (detail: " + sqle.getMessage() + ")";
                        return false;
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    protected void afterConfigurationLoaded() throws ConfigurationException {
        this.setConfluenceLicenseConfiguration();
        try {
            this.clusterConfigurationHelper.bootstrapCluster();
        }
        catch (ClusterException ex) {
            throw new ConfigurationException("Exception bootstrapping cluster:" + ex.getMessage(), (Throwable)ex);
        }
    }

    private void setConfluenceLicenseConfiguration() {
        LicenseManager.getInstance().addLicenseConfiguration("CONF", (LicenseTypeStore)new ConfluenceLicenseTypeStore(), (LicenseRegistry)new ConfluenceLicenseRegistry());
    }

    protected void postBootstrapDatabase() {
        Properties databaseProperties = this.getHibernateProperties();
        try {
            this.databaseHelper.setDatabaseLowerProperty(databaseProperties, this.applicationConfig);
        }
        catch (BootstrapException e) {
            log.error((Object)("Exception while checking for lowercasing support of database for non ascii characters: " + (Object)((Object)e)), (Throwable)e);
        }
    }

    public String getWebAppContextPath() {
        return this.getString("confluence.webapp.context.path");
    }

    public void setWebAppContextPath(String webAppContextPath) throws ConfigurationException {
        this.setProperty("confluence.webapp.context.path", webAppContextPath);
    }

    public boolean isWebAppContextPathSet() {
        return this.getWebAppContextPath() != null;
    }

    public void setDatabaseHelper(DatabaseHelper databaseHelper) {
        this.databaseHelper = databaseHelper;
    }

    public void setClusterConfigurationHelper(ClusterConfigurationHelper clusterConfigurationHelper) {
        this.clusterConfigurationHelper = clusterConfigurationHelper;
    }

    static {
        databaseDialectConversions.put("net.sf.hibernate.dialect.DB2Dialect", DB2Dialect.class.getName());
        databaseDialectConversions.put("bucket.dialect.MySQLDialect", MySQLDialect.class.getName());
        databaseDialectConversions.put("com.atlassian.confluence.util.DB2Dialect", DB2Dialect.class.getName());
    }
}

