/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.setup.SetupException;
import com.atlassian.config.setup.SetupPersister;
import com.atlassian.core.util.PairType;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Category;

public class DefaultSetupPersister
implements SetupPersister {
    private static final Category log = Category.getInstance(DefaultSetupPersister.class);
    private static final String PROPERTY_DEMO_CONTENT_INSTALLED = "confluence.democontent.installed";
    private Stack setupStack;
    private Stack finishedStack;
    private ApplicationConfiguration applicationConfig;
    public static final String SETUP_TYPE_CLUSTER = "cluster";

    public void setApplicationConfig(ApplicationConfiguration applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    private Stack getSetupStack() {
        if (this.setupStack == null) {
            this.configureSetupSequence(this.getSetupType());
        }
        return this.setupStack;
    }

    protected void configureSetupSequence(String setupType) {
        this.setupStack = new Stack();
        this.finishedStack = new Stack();
        if ("initial".equals(setupType)) {
            this.setupStack.add(new PairType((Serializable)((Object)"complete"), (Serializable)((Object)"step3.setup.is.complete")));
            this.setupStack.add(new PairType((Serializable)((Object)"finishsetup"), (Serializable)((Object)"invisible")));
            this.setupStack.add(new PairType((Serializable)((Object)"setupdemocontent"), (Serializable)((Object)"invisible")));
            this.setupStack.add(new PairType((Serializable)((Object)"setupadministrator-start"), (Serializable)((Object)"step2.create.administrator")));
            this.setupStack.add(new PairType((Serializable)((Object)"setuppaths"), (Serializable)((Object)"invisible")));
            this.setupStack.add(new PairType((Serializable)((Object)"setupembeddeddb-default"), (Serializable)((Object)"invisible")));
            this.setupStack.add(new PairType((Serializable)((Object)"setuplicense"), (Serializable)((Object)"step1.install.license")));
        } else if ("install".equals(setupType)) {
            this.setupStack.add(new PairType((Serializable)((Object)"complete"), (Serializable)((Object)"step3.setup.is.complete")));
            this.setupStack.add(new PairType((Serializable)((Object)"finishsetup"), (Serializable)((Object)"invisible")));
            this.setupStack.add(new PairType((Serializable)((Object)"setupadministrator-start"), (Serializable)((Object)"step2.create.administrator")));
            this.setupStack.add(new PairType((Serializable)((Object)"setupdemocontent"), (Serializable)((Object)"invisible")));
            this.setupStack.add(new PairType((Serializable)((Object)"setuppaths"), (Serializable)((Object)"invisible")));
            this.setupStack.add(new PairType((Serializable)((Object)"setupembeddeddb-default"), (Serializable)((Object)"invisible")));
            this.setupStack.add(new PairType((Serializable)((Object)"setuplicense"), (Serializable)((Object)"step1.install.license")));
        } else if ("custom".equals(setupType)) {
            this.setupStack.add(new PairType((Serializable)((Object)"complete"), (Serializable)((Object)"step5.setup.is.complete")));
            this.setupStack.add(new PairType((Serializable)((Object)"finishsetup"), (Serializable)((Object)"invisible")));
            this.setupStack.add(new PairType((Serializable)((Object)"setupadministrator-start"), (Serializable)((Object)"step4.create.administrator")));
            this.setupStack.add(new PairType((Serializable)((Object)"setupdata-start"), (Serializable)((Object)"step3.load.content")));
            this.setupStack.add(new PairType((Serializable)((Object)"setuppaths"), (Serializable)((Object)"invisible")));
            this.setupStack.add(new PairType((Serializable)((Object)"setupdbchoice-start"), (Serializable)((Object)"step2.configure.database")));
            this.setupStack.add(new PairType((Serializable)((Object)"setuplicense"), (Serializable)((Object)"step1.install.license")));
        } else if (SETUP_TYPE_CLUSTER.equals(setupType)) {
            this.setupStack.add(new PairType((Serializable)((Object)"complete"), (Serializable)((Object)"step6.setup.is.complete")));
            this.setupStack.add(new PairType((Serializable)((Object)"finishsetup"), (Serializable)((Object)"invisible")));
            this.setupStack.add(new PairType((Serializable)((Object)"setupadministrator-start"), (Serializable)((Object)"step5.create.administrator")));
            this.setupStack.add(new PairType((Serializable)((Object)"setupdata-start"), (Serializable)((Object)"step4.load.content")));
            this.setupStack.add(new PairType((Serializable)((Object)"setuppaths"), (Serializable)((Object)"invisible")));
            this.setupStack.add(new PairType((Serializable)((Object)"setupdb-start"), (Serializable)((Object)"step3.configure.database")));
            this.setupStack.add(new PairType((Serializable)((Object)"setupcluster-start"), (Serializable)((Object)"step2.configure.cluster")));
            this.setupStack.add(new PairType((Serializable)((Object)"setuplicense"), (Serializable)((Object)"step1.install.license")));
        }
        String currentStep = this.getCurrentStep();
        this.synchSetupStackWithConfigRecord(currentStep);
    }

    private void synchSetupStackWithConfigRecord(String currentStep) {
        if (currentStep != null) {
            for (PairType pairType : this.getSetupStack()) {
                if (!pairType.getKey().equals(currentStep)) continue;
                while (!((PairType)this.getSetupStack().peek()).getKey().equals(currentStep)) {
                    this.finishedStack.push(this.getSetupStack().pop());
                }
            }
        }
    }

    public List getUncompletedSteps() {
        Iterator iter = this.getSetupStack().iterator();
        ArrayList reversedSteps = new ArrayList();
        while (iter.hasNext()) {
            reversedSteps.add(iter.next());
        }
        Collections.reverse(reversedSteps);
        return reversedSteps;
    }

    public List getCompletedSteps() {
        return this.finishedStack.subList(0, this.finishedStack.size());
    }

    public String getSetupType() {
        return this.applicationConfig.getSetupType();
    }

    public void setSetupType(String setupType) {
        if (!TextUtils.stringSet((String)setupType)) {
            setupType = "initial";
        }
        try {
            this.applicationConfig.setSetupType(setupType);
            this.applicationConfig.save();
            this.configureSetupSequence(setupType);
        }
        catch (ConfigurationException e) {
            log.error((Object)("Could not save setupType:" + (Object)((Object)e)));
        }
    }

    public void finishSetup() throws SetupException {
        String currentStep = this.getCurrentStep();
        if (currentStep != "complete") {
            throw new SetupException("Tried to finish setup but had not run through the whole wizard?");
        }
        try {
            this.applicationConfig.setSetupComplete(true);
            this.applicationConfig.removeProperty((Object)PROPERTY_DEMO_CONTENT_INSTALLED);
            this.applicationConfig.save();
        }
        catch (ConfigurationException e) {
            log.fatal((Object)("Error writing state to confluence.cfg.xml: " + e.getMessage()));
        }
    }

    public void progessSetupStep() {
        try {
            PairType completedPair = (PairType)this.getSetupStack().pop();
            this.finishedStack.push(completedPair);
            if (!this.getSetupStack().empty()) {
                String newCurrentStep = (String)((Object)((PairType)this.getSetupStack().peek()).getKey());
                this.setCurrentStep(newCurrentStep);
            } else {
                log.error((Object)"setupStack is empty of actions.");
            }
        }
        catch (EmptyStackException e) {
            log.error((Object)"The setupStack is empty; the last action should always be 'complete', which will prohibit further setupStack activity! Odds are it wasn't in this case.");
        }
    }

    public String getCurrentStep() {
        String currentStep = this.applicationConfig.getCurrentSetupStep();
        if (!TextUtils.stringSet((String)currentStep)) {
            currentStep = (String)((Object)((PairType)this.getSetupStack().peek()).getKey());
            this.setCurrentStep(currentStep);
        }
        return currentStep;
    }

    private void setCurrentStep(String newCurrentStep) {
        this.applicationConfig.setCurrentSetupStep(newCurrentStep);
        try {
            this.applicationConfig.save();
        }
        catch (ConfigurationException e) {
            log.error((Object)"unable to record current bootstrapManager step to confluence.cfg.xml");
        }
    }

    public void setDemonstrationContentInstalled() {
        this.applicationConfig.setProperty((Object)PROPERTY_DEMO_CONTENT_INSTALLED, (Object)"true");
    }

    public boolean isDemonstrationContentInstalled() {
        return "true".equals(this.applicationConfig.getProperty((Object)PROPERTY_DEMO_CONTENT_INSTALLED));
    }
}

