/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.license.SIDManager;

public class SetupSidManager
implements ConfluenceSidManager {
    private SIDManager sidManager;
    private ApplicationConfiguration applicationConfig;
    public static final String CONFLUENCE_SETUP_SERVER_ID = "confluence.setup.server.id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSid() throws ConfigurationException {
        if (this.isSidSet()) {
            throw new ConfigurationException("Server ID already initialised");
        }
        String sid = this.sidManager.generateSID();
        ApplicationConfiguration applicationConfiguration = this.applicationConfig;
        synchronized (applicationConfiguration) {
            this.applicationConfig.setProperty((Object)CONFLUENCE_SETUP_SERVER_ID, (Object)sid);
            this.applicationConfig.save();
        }
    }

    public String getSid() throws ConfigurationException {
        return (String)this.applicationConfig.getProperty((Object)CONFLUENCE_SETUP_SERVER_ID);
    }

    public boolean isSidSet() throws ConfigurationException {
        return this.getSid() != null;
    }

    public void setSidManager(SIDManager sidManager) {
        this.sidManager = sidManager;
    }

    public void setApplicationConfig(ApplicationConfiguration applicationConfig) {
        this.applicationConfig = applicationConfig;
    }
}

