/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.setup.actions.AbstractSetupAction;
import com.atlassian.core.logging.DatedLoggingEvent;
import com.atlassian.core.logging.ThreadLocalErrorCollection;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public abstract class AbstractSetupDatabaseAction
extends AbstractSetupAction {
    public static final Category log = Category.getInstance(AbstractSetupDatabaseAction.class);
    private String database;
    protected DatabaseDetails dbDetails = new DatabaseDetails();
    private HibernateConfig hibernateConfig;

    public HibernateConfig getHibernateConfig() {
        if (this.hibernateConfig == null) {
            this.hibernateConfig = BootstrapUtils.getBootstrapManager().getHibernateConfig();
        }
        return this.hibernateConfig;
    }

    public void setHibernateConfig(HibernateConfig hibernateConfig) {
        this.hibernateConfig = hibernateConfig;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    protected List getErrorLevelLogsEvents() {
        ArrayList<LoggingEvent> result = new ArrayList<LoggingEvent>();
        List list = ThreadLocalErrorCollection.getList();
        if (list.size() > 0) {
            for (DatedLoggingEvent dle : list) {
                LoggingEvent loggingEvent = dle.getEvent();
                if (!loggingEvent.getLevel().isGreaterOrEqual(Priority.ERROR)) continue;
                result.add(loggingEvent);
            }
        }
        return result;
    }

    protected void registerLoggingErrorEventsWithAction(List loggingEvents) {
        for (LoggingEvent loggingEvent : loggingEvents) {
            if (!loggingEvent.getLevel().isGreaterOrEqual(Priority.ERROR)) continue;
            this.addActionError(this.renderLoggingEvent(loggingEvent));
        }
    }

    private String renderLoggingEvent(LoggingEvent loggingEvent) {
        String result = loggingEvent.getRenderedMessage();
        if (loggingEvent.getThrowableInformation() != null) {
            result = result + ": " + loggingEvent.getThrowableInformation().getThrowable().getMessage();
        }
        return result;
    }

    public DatabaseDetails getDbConfigInfo() {
        return this.dbDetails;
    }

    public void setDbConfigInfo(DatabaseDetails dbDetails) {
        this.dbDetails = dbDetails;
    }
}

