/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.cluster.ClusterAlreadyExistsException;
import com.atlassian.confluence.cluster.ClusterConfigurationHelper;
import com.atlassian.confluence.cluster.ClusterException;
import com.atlassian.confluence.cluster.ClusterInformation;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.NoSuchClusterException;
import com.atlassian.confluence.setup.SharedConfigurationMap;
import com.atlassian.confluence.setup.actions.AbstractSetupAction;
import com.atlassian.license.LicenseManager;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;

public class SetupClusterAction
extends AbstractSetupAction {
    private static final Logger log = Logger.getLogger(SetupClusterAction.class);
    private static final String SETUP_CLUSTER = "cluster";
    private static final String NEW_CLUSTER = "newCluster";
    private static final String JOIN_CLUSTER = "joinCluster";
    private String setupClusterType;
    private String clusterName;
    private ClusterManager clusterManager;
    private String networkInterface;
    private ClusterConfigurationHelper clusterConfigurationHelper;

    public void validate() {
        super.validate();
        if (!TextUtils.stringSet((String)this.getSetupClusterType())) {
            this.addActionError(this.getText("error.no.cluster.setup.type"));
        }
    }

    public String execute() throws Exception {
        if (!TextUtils.stringSet((String)this.clusterName)) {
            this.addActionError(this.getText("no.cluster.name"));
            return "error";
        }
        String setupType = this.getSetupClusterType();
        if (NEW_CLUSTER.equals(setupType)) {
            if (!this.createNamedCluster(this.clusterName, this.networkInterface)) {
                return "error";
            }
            this.getSetupPersister().progessSetupStep();
            return "setupdb";
        }
        if (!this.joinNamedCluster(this.clusterName, this.networkInterface)) {
            return "error";
        }
        SharedConfigurationMap config = this.getSharedConfig();
        if (config == null) {
            this.addActionError(this.getText("no.published.config", new Object[]{this.clusterName}));
            return "error";
        }
        this.getBootstrapManager().bootstrapSharedConfiguration(config);
        while (TextUtils.stringSet((String)this.getSetupPersister().getCurrentStep()) && !"complete".equals(this.getSetupPersister().getCurrentStep())) {
            this.getSetupPersister().progessSetupStep();
        }
        return SETUP_CLUSTER;
    }

    private String getSetupClusterType() {
        if (this.setupClusterType == null) {
            if (TextUtils.stringSet((String)ServletActionContext.getRequest().getParameter(NEW_CLUSTER))) {
                this.setupClusterType = NEW_CLUSTER;
            } else if (TextUtils.stringSet((String)ServletActionContext.getRequest().getParameter(JOIN_CLUSTER))) {
                this.setupClusterType = JOIN_CLUSTER;
            }
        }
        return this.setupClusterType;
    }

    private boolean createNamedCluster(String name, String networkInterface) {
        try {
            this.getClusterConfigurationHelper().createCluster(name, networkInterface);
            return true;
        }
        catch (ClusterAlreadyExistsException ex) {
            this.addActionError(this.getText("cluster.already.exists", new Object[]{ex.getClusterName(), ex.getClusterAddress().getHostAddress()}));
            return false;
        }
        catch (ClusterException ex) {
            this.addActionError(ex.getMessage());
            log.error((Object)("There was a problem creating the cluster with name '" + name + "'"), (Throwable)ex);
            return false;
        }
    }

    private boolean joinNamedCluster(String name, String networkInterface) {
        try {
            this.getClusterConfigurationHelper().joinCluster(name, networkInterface);
        }
        catch (NoSuchClusterException ex) {
            this.addActionError(this.getText("no.such.cluster", new Object[]{ex.getClusterName(), ex.getClusterAddress().getHostAddress()}));
            return false;
        }
        catch (ClusterException ex) {
            this.addActionError(ex.getMessage());
            log.error((Object)("There was a problem joining the cluster with name '" + name + "'"), (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean isClusterDetected() {
        return this.getClusterManager().isClustered() && this.getClusterInformation().getMemberCount() > 1;
    }

    public boolean isThisNodeClustered() {
        return this.getClusterManager().isClustered();
    }

    public boolean isLicenceClustered() {
        return LicenseManager.getInstance().getLicense("CONF").getPermittedClusteredNodes() > 0;
    }

    public boolean isSharedConfigPublished() {
        return this.isClusterDetected() && this.getSharedConfig() != null;
    }

    public boolean isSharedConfigUsingEmbedded() {
        return this.getSharedConfig() != null && this.getSharedConfig().get((Serializable)((Object)"hibernate.dialect")).equals("net.sf.hibernate.dialect.HSQLDialect");
    }

    public SharedConfigurationMap getSharedConfig() {
        return (SharedConfigurationMap)this.getClusterManager().getPublishedObject("sharedConfig");
    }

    public ClusterInformation getClusterInformation() {
        return this.clusterManager.getClusterInformation();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getNetworkInterface() {
        return this.networkInterface;
    }

    public void setNetworkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public ClusterManager getClusterManager() {
        if (this.clusterManager == null) {
            this.setClusterManager((ClusterManager)BootstrapUtils.getBootstrapContext().getBean("clusterManager"));
        }
        return this.clusterManager;
    }

    public ClusterConfigurationHelper getClusterConfigurationHelper() {
        if (this.clusterConfigurationHelper == null) {
            this.setClusterConfigurationHelper((ClusterConfigurationHelper)BootstrapUtils.getBootstrapContext().getBean("clusterConfigurationHelper"));
        }
        return this.clusterConfigurationHelper;
    }

    public void setClusterConfigurationHelper(ClusterConfigurationHelper clusterConfigurationHelper) {
        this.clusterConfigurationHelper = clusterConfigurationHelper;
    }

    public List getClusterableInterfaces() {
        return this.getClusterConfigurationHelper().getClusterableInterfaces();
    }
}

