/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.confluence.setup.actions.AbstractSetupStandardDatabaseAction;
import org.apache.log4j.Category;

public class SetupEmbeddedDatabaseAction
extends AbstractSetupStandardDatabaseAction {
    public static final Category log = Category.getInstance(SetupEmbeddedDatabaseAction.class);

    public String execute() throws ConfigurationException {
        this.setDatabase("hsqldb");
        DatabaseDetails dbconfig = DatabaseDetails.getDefaults((String)"hsqldb");
        this.setDbConfigInfo(dbconfig);
        if ("install".equals(this.getSetupPersister().getSetupType())) {
            return this.setupDatabase("quick-setup");
        }
        if ("custom".equals(this.getSetupPersister().getSetupType())) {
            return this.setupDatabase("custom-setup");
        }
        throw new IllegalStateException("Unrecognised setup type: " + this.getSetupPersister().getSetupType());
    }

    public String setupDatabase(String successfulReturnValue) {
        if (!this.checkDriver(this.getDbConfigInfo())) {
            return "error";
        }
        try {
            this.getDbConfigInfo().setupForDatabase(this.getDatabase());
            this.getBootstrapManager().bootstrapDatabase(this.getDbConfigInfo(), true);
        }
        catch (BootstrapException e) {
            this.addActionError(this.getText("configuring.db.failed"));
            this.addActionError(e.getMessage());
            this.registerLoggingErrorEventsWithAction(this.getErrorLevelLogsEvents());
            return "error";
        }
        this.getSetupPersister().progessSetupStep();
        return successfulReturnValue;
    }
}

