/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.actions.AbstractSetupAction;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.util.PairType;
import com.opensymphony.webwork.ServletActionContext;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.apache.webdav.lib.WebdavResource;

public class SetupPathsAction
extends AbstractSetupAction {
    private static final Logger log = Logger.getLogger(SetupPathsAction.class);
    private String specificBackupDir;
    private List backupTypes;
    private String backupType;
    private List attachmentStorageTypes;
    private String attachmentStorageType;
    private String webdavServerUrl;
    private String webdavUsername;
    private String webdavPassword;

    public String execute() throws Exception {
        String setupType = this.getSetupPersister().getSetupType();
        Settings settings = this.settingsManager.getGlobalSettings();
        String currentBackupDir = this.getBootstrapManager().getString("daily.backup.dir");
        String confHome = this.getBootstrapManager().getConfluenceHome() + System.getProperty("file.separator");
        String currentWebdavServerUrl = settings.getWebdavServerUrl();
        if (currentBackupDir == null || currentBackupDir.equals(confHome + "backups")) {
            this.backupType = "automatic.backups";
            this.specificBackupDir = "${confluenceHome}";
        } else if (currentBackupDir.equals("")) {
            this.backupType = "disable.backups";
            this.specificBackupDir = "${confluenceHome}";
        } else {
            this.backupType = "specify.backup.dir";
            this.specificBackupDir = currentBackupDir;
        }
        if ("cluster".equals(setupType)) {
            this.attachmentStorageType = "database.based.attachments.storage";
        } else if (currentWebdavServerUrl == null || currentBackupDir.trim().equals("")) {
            this.attachmentStorageType = "file.system.based.attachments.storage";
            this.webdavServerUrl = currentWebdavServerUrl;
        } else {
            this.attachmentStorageType = "webdav.based.attachments.storage";
            this.webdavServerUrl = currentWebdavServerUrl;
            this.webdavUsername = settings.getWebdavUsername();
            this.webdavPassword = settings.getWebdavPassword();
        }
        if (this.getBootstrapManager().isSetupComplete()) {
            return "input";
        }
        String confluenceHomeVelocityExpression = "${confluenceHome}" + System.getProperty("file.separator");
        BootstrapManager confSetup = this.getBootstrapManager();
        this.setupAttachmentPaths();
        if ("automatic.backups".equals(this.backupType)) {
            this.setupDirectory(confluenceHomeVelocityExpression + "backups", "backupType", "creating.daily.backup.dir.failed");
            confSetup.setProperty("daily.backup.dir", confluenceHomeVelocityExpression + "backups");
        } else if ("specify.backup.dir".equals(this.backupType)) {
            this.setupDirectory(this.specificBackupDir, "specificBackupDir", "creating.daily.backup.dir.failed");
            confSetup.setProperty("daily.backup.dir", this.specificBackupDir);
        } else {
            confSetup.setProperty("daily.backup.dir", "");
        }
        if (this.hasErrors()) {
            return "error";
        }
        try {
            settings.setAttachmentDataStore(this.attachmentStorageType);
            settings.setBaseUrl(GeneralUtil.lookupDomainName(ServletActionContext.getRequest()));
            this.settingsManager.updateGlobalSettings(settings);
            if ("install".equals(setupType)) {
                this.getSetupPersister().progessSetupStep();
                return "quick-setup";
            }
            if ("custom".equals(setupType) || "cluster".equals(setupType)) {
                this.getSetupPersister().progessSetupStep();
                return "custom-setup";
            }
            throw new RuntimeException("Unexpected setup type:" + setupType);
        }
        catch (Exception e) {
            log.error((Object)"Unable to setup paths to system", (Throwable)e);
            this.addActionError(this.getText("error.recording.default.paths.to.system"));
            return "error";
        }
    }

    private void setupAttachmentPaths() {
        String confHome = "${confluenceHome}" + System.getProperty("file.separator");
        BootstrapManager confSetup = this.getBootstrapManager();
        Settings settings = this.settingsManager.getGlobalSettings();
        confSetup.setProperty("attachments.dir", confHome + "attachments");
        this.setupDirectory(confHome + "attachments", "attachmentsDir", "creating.attachments.dir.failed");
        if ("file.system.based.attachments.storage".equals(this.attachmentStorageType)) {
            settings.setWebdavServerUrl(null);
        } else if (!"database.based.attachments.storage".equals(this.attachmentStorageType)) {
            this.checkWebDavConnection();
            if (!this.hasErrors()) {
                settings.setWebdavServerUrl(this.webdavServerUrl);
                settings.setWebdavUsername(this.webdavUsername);
                settings.setWebdavPassword(this.webdavPassword);
            }
        }
        this.settingsManager.updateGlobalSettings(settings);
    }

    private void checkWebDavConnection() {
        try {
            HttpURL httpURL = SetupPathsAction.uriToHttpURL(this.webdavServerUrl);
            httpURL.setUserinfo(this.webdavUsername, this.webdavPassword);
            new WebdavResource(httpURL);
        }
        catch (Exception ex) {
            this.addActionError(this.handleException(ex));
        }
    }

    private static HttpURL uriToHttpURL(String uri) throws URIException {
        return uri.startsWith("https") ? new HttpsURL(uri.toCharArray()) : new HttpURL(uri.toCharArray());
    }

    private String handleException(Exception ex) {
        if (ex instanceof HttpException) {
            if (((HttpException)((Object)ex)).getReasonCode() == 405) {
                return "Warning: Not WebDAV-enabled?";
            }
            if (((HttpException)((Object)ex)).getReasonCode() == 401) {
                return "Could not connect to WebDav server: Incorrect username and password";
            }
            return "Warning: " + ex.getMessage();
        }
        if (ex instanceof IOException) {
            return "Error: " + ex.getMessage();
        }
        return "FATAL error";
    }

    private File setupDirectory(String dirName, String fieldName, String failureMessageKey) {
        File dir;
        if (dirName == null || dirName.trim().equals("")) {
            return null;
        }
        if (dirName.startsWith("${confluenceHome}")) {
            dirName = this.getBootstrapManager().getConfluenceHome() + dirName.substring("${confluenceHome}".length());
        }
        if (!(dir = new File(dirName)).isDirectory() && !dir.mkdirs()) {
            this.addFieldError(fieldName, this.getText(failureMessageKey));
            return null;
        }
        return dir;
    }

    public boolean isWebDavConfigured() {
        return this.settingsManager.getGlobalSettings().isWebdavEnabled();
    }

    public List getBackupTypes() {
        if (this.backupTypes == null) {
            this.backupTypes = new ArrayList();
            this.backupTypes.add(new PairType((Serializable)((Object)this.getText("automatic.backups")), (Serializable)((Object)"automatic.backups")));
            this.backupTypes.add(new PairType((Serializable)((Object)this.getText("disable.backups")), (Serializable)((Object)"disable.backups")));
            this.backupTypes.add(new PairType((Serializable)((Object)this.getText("specify.backup.dir")), (Serializable)((Object)"specify.backup.dir")));
        }
        return this.backupTypes;
    }

    public String getBackupType() {
        return this.backupType;
    }

    public void setBackupType(String backupType) {
        this.backupType = backupType;
    }

    public String getSpecificBackupDir() {
        return this.specificBackupDir;
    }

    public void setSpecificBackupDir(String specificBackupDir) {
        this.specificBackupDir = specificBackupDir;
    }

    public List getAttachmentStorageTypes() {
        if (this.attachmentStorageTypes == null) {
            this.attachmentStorageTypes = new ArrayList();
            this.attachmentStorageTypes.add(new PairType((Serializable)((Object)this.getText("file.system.based.attachments.storage")), (Serializable)((Object)"file.system.based.attachments.storage")));
            this.attachmentStorageTypes.add(new PairType((Serializable)((Object)this.getText("webdav.based.attachments.storage")), (Serializable)((Object)"webdav.based.attachments.storage")));
            this.attachmentStorageTypes.add(new PairType((Serializable)((Object)this.getText("database.based.attachments.storage")), (Serializable)((Object)"database.based.attachments.storage")));
        }
        return this.attachmentStorageTypes;
    }

    public void setAttachmentStorageTypes(List attachmentStorageTypes) {
        this.attachmentStorageTypes = attachmentStorageTypes;
    }

    public String getAttachmentStorageType() {
        return this.attachmentStorageType;
    }

    public void setAttachmentStorageType(String attachmentStorageType) {
        this.attachmentStorageType = attachmentStorageType;
    }

    public String getWebdavServerUrl() {
        return this.webdavServerUrl;
    }

    public void setWebdavServerUrl(String webdavServerUrl) {
        this.webdavServerUrl = webdavServerUrl;
    }

    public String getWebdavUsername() {
        return this.webdavUsername;
    }

    public void setWebdavUsername(String webdavUsername) {
        this.webdavUsername = webdavUsername;
    }

    public String getWebdavPassword() {
        return this.webdavPassword;
    }

    public void setWebdavPassword(String webdavPassword) {
        this.webdavPassword = webdavPassword;
    }
}

