/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.confluence.setup.actions.AbstractSetupStandardDatabaseAction;
import com.opensymphony.webwork.ServletActionContext;
import java.sql.Connection;
import java.sql.SQLException;

public class SetupStandardDatabaseAction
extends AbstractSetupStandardDatabaseAction {
    static final String DATA_EXISTS = "data-exists";
    private boolean forceOverwriteExistingData = false;

    public String doDefault() throws Exception {
        this.dbDetails = DatabaseDetails.getDefaults((String)this.getDatabase());
        return super.doDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        if (!this.checkDriver(this.getDbConfigInfo())) {
            return "error";
        }
        this.dbDetails.setupForDatabase(this.getDatabase());
        Connection connection = null;
        try {
            connection = this.getBootstrapManager().getTestDatabaseConnection(this.dbDetails);
            if (!this.forceOverwriteExistingData && this.getBootstrapManager().databaseContainsExistingData(connection)) {
                this.addActionError(this.getText("setup.database.tables.exist"));
                String string = DATA_EXISTS;
                return string;
            }
        }
        catch (Exception e) {
            this.addActionError(this.getText("configuring.db.failed"));
            this.addActionError(e.getMessage());
            log.error((Object)("Unable to connect to database: " + e.getMessage()), (Throwable)e);
            String string = "error";
            return string;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {}
        }
        try {
            if ("hsqldb".equals(this.getDatabase().toLowerCase())) {
                this.getBootstrapManager().bootstrapDatabase(this.dbDetails, true);
            } else {
                this.getBootstrapManager().bootstrapDatabase(this.dbDetails, false);
            }
        }
        catch (Exception e) {
            this.addActionError(this.getText("configuring.db.failed"));
            this.addActionError(e.getMessage());
            this.registerLoggingErrorEventsWithAction(this.getErrorLevelLogsEvents());
            return "error";
        }
        ServletActionContext.getContext().getSession().remove("dbConfig");
        this.getSetupPersister().progessSetupStep();
        return "success";
    }

    public void setForceOverwriteExistingData(boolean forceOverwriteExistingData) {
        this.forceOverwriteExistingData = forceOverwriteExistingData;
    }
}

