/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.bandana;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaPersister;
import com.atlassian.cache.Cache;
import com.atlassian.confluence.cache.ReadThroughCacheFactory;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaCacheKey;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;

public class ConfluenceCachingBandanaPersister
implements BandanaPersister {
    public static final Category log = Category.getInstance(ConfluenceCachingBandanaPersister.class);
    private static final String CACHE_KEY_BANDANA_PERSISTER = BandanaPersister.class.getName();
    private BandanaPersister persister;
    private ReadThroughCacheFactory cacheFactory;

    public void setCacheFactory(ReadThroughCacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public void setPersister(BandanaPersister persister) {
        this.persister = persister;
    }

    private Cache getCache() {
        return this.cacheFactory.getCache(CACHE_KEY_BANDANA_PERSISTER);
    }

    public Object retrieve(BandanaContext context, String key) {
        ConfluenceBandanaCacheKey cacheKey = new ConfluenceBandanaCacheKey((ConfluenceBandanaContext)context, key);
        Object result = this.getCache().get((Object)cacheKey);
        if (EmptyCachePlaceholder.INSTANCE.equals(result)) {
            return null;
        }
        if (result != null) {
            return result;
        }
        result = this.persister.retrieve(context, key);
        Cache readThroughCache = this.cacheFactory.getReadThroughCacheForUpdate(CACHE_KEY_BANDANA_PERSISTER);
        readThroughCache.put((Object)cacheKey, result != null ? result : EmptyCachePlaceholder.INSTANCE);
        return result;
    }

    public Map retrieve(BandanaContext context) {
        Set keys = this.persister.retrieve(context).keySet();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : keys) {
            result.put(key, this.retrieve(context, key));
        }
        return result;
    }

    public void store(BandanaContext context, String key, Object value) {
        this.persister.store(context, key, value);
        this.getCache().put((Object)new ConfluenceBandanaCacheKey((ConfluenceBandanaContext)context, key), value);
    }

    public void flushCaches() {
        this.getCache().removeAll();
    }

    public void remove(BandanaContext context) {
        this.persister.remove(context);
        this.getCache().removeAll();
    }

    public void remove(BandanaContext context, String key) {
        this.persister.remove(context, key);
        this.getCache().remove((Object)new ConfluenceBandanaCacheKey((ConfluenceBandanaContext)context, key));
    }

    private static final class EmptyCachePlaceholder
    implements Serializable {
        private static final EmptyCachePlaceholder INSTANCE = new EmptyCachePlaceholder();

        private Object readResolve() {
            return INSTANCE;
        }

        private EmptyCachePlaceholder() {
        }
    }
}

