/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.quartz;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusteredLock;
import com.atlassian.confluence.setup.quartz.ConfluenceQuartzUtil;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Category;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.TriggerListener;

public class ClusteredTriggerListener
implements TriggerListener {
    private static Category log = Category.getInstance(ClusteredTriggerListener.class);
    private final ClusterManager clusterManager;

    public ClusteredTriggerListener(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void triggerFired(Trigger trigger, JobExecutionContext jobExecutionContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext jobExecutionContext) {
        if (ConfluenceQuartzUtil.isRunOncePerCluster(jobExecutionContext)) {
            ClusteredLock lock = this.clusterManager.getClusteredLock(jobExecutionContext.getJobDetail().getFullName());
            if (lock.tryLock()) {
                try {
                    Date executionDate = (Date)lock.getValue();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("trigger = " + trigger.getName() + ", executionDate = " + this.formatDate(executionDate) + ", fireTime = " + this.formatDate(jobExecutionContext.getScheduledFireTime()) + ", now = " + this.formatDate(new Date())));
                    }
                    if (executionDate == null || executionDate.before(jobExecutionContext.getScheduledFireTime())) {
                        lock.setValue(jobExecutionContext.getScheduledFireTime());
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            return true;
        }
        return false;
    }

    public void triggerMisfired(Trigger trigger) {
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext jobExecutionContext, int i) {
    }

    private String formatDate(Date d) {
        if (d == null) {
            return "(null)";
        }
        NumberFormat nf = NumberFormat.getIntegerInstance();
        SimpleDateFormat df = (SimpleDateFormat)SimpleDateFormat.getTimeInstance();
        nf.setMinimumIntegerDigits(3);
        return df.format(d) + "." + nf.format(d.getTime() % 1000L);
    }
}

