/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.xstream;

import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.core.util.ClassLoaderUtils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.util.Map;
import org.apache.log4j.Category;

public class XStreamManager {
    private static final Category log = Category.getInstance(XStreamManager.class);
    private XStream xstream;
    private Map aliases;
    private ClassLoader classLoader;

    public XStreamManager(Map aliases) {
        this(aliases, null);
    }

    public XStreamManager(Map aliases, ClassLoader classLoader) {
        this.aliases = aliases;
        this.classLoader = classLoader == null ? XStreamManager.class.getClassLoader() : classLoader;
        this.resetXStream();
    }

    public XStream getXstream() {
        return this.xstream;
    }

    public void resetXStream() {
        this.xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider());
        this.xstream.setClassLoader(this.classLoader);
        for (String alias : this.aliases.keySet()) {
            String aliasClassName = (String)this.aliases.get(alias);
            try {
                Class aliasClass = ClassLoaderUtils.loadClass((String)aliasClassName, XStreamManager.class);
                this.xstream.alias(alias, aliasClass);
            }
            catch (ClassNotFoundException e) {
                throw new InfrastructureException("Error loading XStreamManager - could not find class : " + aliasClassName + " for alias " + alias, (Throwable)e);
            }
        }
    }
}

