/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceGroup;
import com.atlassian.confluence.spaces.SpaceGroupManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.persistence.dao.SpaceGroupDao;
import com.atlassian.license.License;
import com.atlassian.license.LicenseException;
import com.atlassian.license.LicensePair;
import com.atlassian.license.decoder.LicenseDecoder;
import com.opensymphony.util.TextUtils;
import java.util.List;
import org.apache.log4j.Category;

public class DefaultSpaceGroupManager
implements SpaceGroupManager {
    private static Category log = Category.getInstance(DefaultSpaceGroupManager.class);
    private SpaceGroupDao spaceGroupDao;
    private SpaceManager spaceManager;

    public SpaceGroup createSpaceGroup(String key, String name) {
        SpaceGroup spaceGroup = new SpaceGroup();
        spaceGroup.setKey(key);
        spaceGroup.setName(name);
        this.saveSpaceGroup(spaceGroup);
        return spaceGroup;
    }

    public SpaceGroup createSpaceGroup(String key, String name, String creatorName) {
        SpaceGroup spaceGroup = new SpaceGroup();
        spaceGroup.setKey(key);
        spaceGroup.setName(name);
        spaceGroup.setCreatorName(creatorName);
        this.saveSpaceGroup(spaceGroup);
        return spaceGroup;
    }

    public void saveSpaceGroup(SpaceGroup spaceGroup) {
        this.spaceGroupDao.save(spaceGroup);
    }

    public void removeSpaceGroup(SpaceGroup spaceGroup, boolean removeSpaces) {
        if (removeSpaces) {
            this.spaceManager.removeSpacesInGroup(spaceGroup);
        } else {
            for (Space space : this.spaceManager.getSpacesInSpaceGroup(spaceGroup)) {
                space.setSpaceGroup(null);
                this.spaceManager.saveSpace(space);
            }
        }
        this.spaceGroupDao.remove(spaceGroup);
    }

    public SpaceGroup getSpaceGroup(long id) {
        return this.spaceGroupDao.getById(id);
    }

    public SpaceGroup getSpaceGroup(String spaceGroupKey) {
        return this.spaceGroupDao.getSpaceGroup(spaceGroupKey);
    }

    public License getSpaceGroupLicense(SpaceGroup spaceGroup) {
        String licenseKey = spaceGroup.getLicenseKey();
        if (licenseKey == null) {
            return null;
        }
        return this.constructLicenseFromKey(licenseKey);
    }

    public void setSpaceGroupLicense(SpaceGroup spaceGroup, String licenseKey) throws LicenseException {
        if (licenseKey != null && !this.hasValidLicense(licenseKey)) {
            throw new LicenseException("License key not valid");
        }
        spaceGroup.setLicenseKey(licenseKey);
    }

    public void removeSpaceGroupLicense(SpaceGroup spaceGroup) {
        spaceGroup.setLicenseKey(null);
    }

    public List getSpaceGroups() {
        return this.spaceGroupDao.findAll();
    }

    public License getLicenseForSpaceGroup(String spaceGroupKey) {
        SpaceGroup spaceGroup = this.getSpaceGroup(spaceGroupKey);
        String licenseKey = spaceGroup.getLicenseKey();
        if (TextUtils.stringSet((String)licenseKey)) {
            return this.constructLicenseFromKey(licenseKey);
        }
        return null;
    }

    public License getLicenseForSpace(String spaceKey) {
        String licenseKey;
        Space space = this.spaceManager.getSpace(spaceKey);
        SpaceGroup spaceGroup = space.getSpaceGroup();
        if (spaceGroup != null && TextUtils.stringSet((String)(licenseKey = spaceGroup.getLicenseKey()))) {
            return this.constructLicenseFromKey(licenseKey);
        }
        return null;
    }

    private License constructLicenseFromKey(String licenseString) {
        License license = null;
        String applicationName = "CONF";
        LicensePair pair = null;
        try {
            pair = new LicensePair(licenseString);
            license = LicenseDecoder.getLicense((LicensePair)pair, (String)applicationName);
        }
        catch (Exception e) {
            log.error((Object)("Invalid license: " + licenseString), (Throwable)e);
        }
        return license;
    }

    private boolean hasValidLicense(String licenseKey) {
        String applicationName = "CONF";
        LicensePair pair = null;
        try {
            pair = new LicensePair(licenseKey);
            License updatedLicense = LicenseDecoder.getLicense((LicensePair)pair, (String)applicationName);
            return LicenseDecoder.isValid((LicensePair)pair, (String)applicationName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setSpaceGroupDao(SpaceGroupDao spaceGroupDao) {
        this.spaceGroupDao = spaceGroupDao;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

