/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaPersister;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.security.ContentPermissionEvent;
import com.atlassian.confluence.event.events.space.SpaceConvertEvent;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.event.events.space.SpaceUpdateEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.mail.MailContentManager;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.search.lucene.ConfluenceIndexManager;
import com.atlassian.confluence.search.lucene.QueuingConfluenceIndexer;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceDescriptionManager;
import com.atlassian.confluence.spaces.SpaceGroup;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.persistence.dao.SpaceDao;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.SpaceComparator;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;

public class DefaultSpaceManager
implements SpaceManager {
    public static final Category log = Category.getInstance(DefaultSpaceManager.class);
    private SpaceDescriptionManager spaceDescriptionManager;
    private SpacePermissionManager spacePermissionManager;
    private PageManager pageManager;
    private DraftManager draftManager;
    private SpaceDao spaceDao;
    private ConfluenceIndexer indexer;
    private BandanaPersister bandanaPersister;
    private EventManager eventManager;
    private ContentPermissionManager contentPermissionManager;
    private MailContentManager mailContentManager;
    private NotificationManager notificationManager;
    private LabelManager labelManager;
    private ConfluenceIndexManager indexManager;
    public static final String DEFAULT_HOMEPAGE_TITLE = "Home";
    public static final String DEFAULT_HOMEPAGE_CONTENT = "This is the home page for the {0} space.";
    public static final String DEFAULT_INDEX_TITLE = "Index";
    public static final String DEFAULT_INDEX_CONTENT = "{index}";
    private PageTemplateManager templateManager;

    public void setSpaceDao(SpaceDao spaceDao) {
        this.spaceDao = spaceDao;
    }

    public boolean isValidSpaceKey(String key) {
        return Space.isValidGlobalSpaceKey(key);
    }

    public boolean isValidPersonalSpaceKey(String key) {
        return Space.isValidPersonalSpaceKey(key);
    }

    public void setSpaceDescriptionManager(SpaceDescriptionManager spaceDescriptionManager) {
        this.spaceDescriptionManager = spaceDescriptionManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public Space getSpace(long id) {
        return this.spaceDao.getById(id);
    }

    public Space getSpace(String exactKey) {
        return this.spaceDao.getSpace(exactKey);
    }

    public Space getPersonalSpace(String username) {
        return this.getSpace(this.getPersonalSpaceKey(username));
    }

    public void setIndexer(ConfluenceIndexer indexer) {
        this.indexer = indexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSpace(Space space) {
        this.indexManager.flushQueue();
        try {
            QueuingConfluenceIndexer.suspendIndexing();
            this.pageManager.removeAllPages(space);
            this.pageManager.removeAllBlogPosts(space);
            this.mailContentManager.removeAllMail(space);
            this.templateManager.removeAllPageTemplates(space);
            this.spacePermissionManager.removeAllPermissions(space);
            this.labelManager.removeAllLabels(space.getDescription());
            List notifs = this.notificationManager.getNotificationsBySpace(space);
            if (notifs != null) {
                Iterator iter = notifs.iterator();
                while (iter.hasNext()) {
                    this.notificationManager.removeNotification((Notification)iter.next());
                }
            }
            if (space.getDescription() != null && space.getId() > 0L) {
                this.spaceDescriptionManager.removeContentEntity(space.getDescription());
            }
            this.spaceDao.remove(space);
        }
        finally {
            QueuingConfluenceIndexer.resumeIndexing();
        }
        this.indexer.unIndexSpace(space);
        this.indexManager.flushQueue();
        this.bandanaPersister.remove((BandanaContext)new ConfluenceBandanaContext(space));
        SpaceRemoveEvent spaceRemoveEvent = new SpaceRemoveEvent(this, space);
        this.eventManager.publishEvent((Event)spaceRemoveEvent);
    }

    public void removeSpacesInGroup(SpaceGroup spaceGroup) {
        for (Space space : new ArrayList(this.getSpacesInSpaceGroup(spaceGroup))) {
            this.removeSpace(space);
        }
    }

    public void saveSpace(Space space) {
        this.saveSpaceNoEvent(space);
        SpaceUpdateEvent updateEvent = new SpaceUpdateEvent(this, space);
        this.eventManager.publishEvent((Event)updateEvent);
    }

    public void saveSpace(Space space, Space originalSpace) {
        this.spaceDescriptionManager.saveContentEntity(space.getDescription(), originalSpace.getDescription(), null);
        this.spaceDao.save(space);
        SpaceUpdateEvent updateEvent = new SpaceUpdateEvent(this, space, originalSpace);
        this.eventManager.publishEvent((Event)updateEvent);
    }

    public List getAllSpaces() {
        return this.spaceDao.findAll();
    }

    public List getSpaces() {
        return this.spaceDao.findAllSpacesSorted("name", SpaceType.GLOBAL);
    }

    public List getSpacesByType(SpaceType type) {
        return this.spaceDao.findAllSpacesSorted("name", type);
    }

    public List getSpacesInSpaceGroup(SpaceGroup spaceGroup) {
        if (spaceGroup == null) {
            return Collections.EMPTY_LIST;
        }
        return this.spaceDao.getSpacesInSpaceGroup(spaceGroup);
    }

    public List getPermittedSpaces(User user) {
        if (GeneralUtil.isSuperUser(user)) {
            return this.getAllSpaces();
        }
        List permittedSpacesForUser = this.spaceDao.getPermittedSpacesForUser(user, "VIEWSPACE");
        Collections.sort(permittedSpacesForUser, new SpaceComparator());
        return permittedSpacesForUser;
    }

    public List getPermittedSpacesByType(User user, SpaceType type) {
        List permittedSpacesForUser = GeneralUtil.isSuperUser(user) ? this.getSpacesByType(type) : this.spaceDao.getPermittedSpacesForUserByType(user, "VIEWSPACE", type);
        Collections.sort(permittedSpacesForUser, new SpaceComparator());
        return permittedSpacesForUser;
    }

    public List getPermittedSpacesInSpaceGroup(User user, SpaceGroup spaceGroup) {
        List permittedSpacesForUser = GeneralUtil.isSuperUser(user) ? this.getSpacesInSpaceGroup(spaceGroup) : this.spaceDao.getPermittedSpacesForUserInSpaceGroup(user, "VIEWSPACE", spaceGroup);
        Collections.sort(permittedSpacesForUser, new SpaceComparator());
        return permittedSpacesForUser;
    }

    public List getEditableSpacesByType(User user, SpaceType type) {
        List permittedSpacesForUser = GeneralUtil.isSuperUser(user) ? this.getSpacesByType(type) : this.spaceDao.getPermittedSpacesForUserByType(user, "EDITSPACE", type);
        Collections.sort(permittedSpacesForUser, new SpaceComparator());
        return permittedSpacesForUser;
    }

    public List getSpacesEditableByUser(User user) {
        List permittedSpacesForUser = GeneralUtil.isSuperUser(user) ? this.spaceDao.findAll() : this.spaceDao.getPermittedSpacesForUser(user, "EDITSPACE");
        Collections.sort(permittedSpacesForUser, new SpaceComparator());
        return permittedSpacesForUser;
    }

    public List getAuthoredSpacesByUser(String username) {
        return this.spaceDao.getSpacesCreatedByUser(username);
    }

    public List getSpacesContainingPagesEditedBy(String username) {
        return this.spaceDao.getSpacesContainingPagesEditedByUser(username);
    }

    public List getSpacesContainingCommentsBy(String username) {
        return this.spaceDao.getSpacesContainingCommentsByUser(username);
    }

    public List getSpacesCreatedOrUpdatedSinceDate(Date previousLoginDate) {
        return this.spaceDao.getSpacesCreatedOrUpdatedSinceDate(previousLoginDate);
    }

    private void rebuildAncestors(Page page, List pagesToIndex) {
        page.getAncestors().clear();
        if (page.getParent() != null) {
            page.getAncestors().addAll(page.getParent().getAncestors());
            page.getAncestors().add(page.getParent());
        }
        pagesToIndex.add(page);
        this.indexer.reIndex(page);
        ArrayList children = new ArrayList(page.getChildren());
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            this.rebuildAncestors((Page)iterator.next(), pagesToIndex);
        }
    }

    public void moveHierarchy(Page topPage, Page newParentPage, Space newSpace, User user, boolean moveChildren, List pagesToIndex) {
        if (topPage == null) {
            throw new IllegalArgumentException("The page to be moved cannot be null.");
        }
        PageMoveEvent pageMoveEvent = new PageMoveEvent((Object)this, topPage, topPage.getParent(), topPage.getSpace(), user, moveChildren);
        this.moveHierarchyRecursive(topPage, newParentPage, newSpace, user, moveChildren, pagesToIndex);
        this.eventManager.publishEvent((Event)pageMoveEvent);
    }

    private void moveHierarchyRecursive(Page topPage, Page newParentPage, Space newSpace, User user, boolean moveChildren, List pagesToIndex) {
        if (topPage == null) {
            throw new IllegalArgumentException("The page to be moved cannot be null.");
        }
        if (newSpace == null) {
            throw new IllegalArgumentException("A page cannot be moved to a null space. Please specify a space.");
        }
        if (newParentPage != null && !newParentPage.isInSpace(newSpace)) {
            throw new IllegalArgumentException("The destination parent '" + newParentPage.getTitle() + "' is not in the destination space '" + newSpace.getName() + "'.");
        }
        Space oldSpace = topPage.getSpace();
        Page oldParentPage = topPage.getParent();
        if (oldParentPage != null && !oldParentPage.equals(newParentPage)) {
            oldParentPage.removeChild(topPage);
        }
        if (!oldSpace.equals(newSpace)) {
            this.pageManager.updateOutgoingLinksInContent(topPage, newSpace.getKey());
            this.pageManager.updateContentLinkingTo(topPage, newSpace.getKey(), null);
            topPage.setSpace(newSpace);
        }
        if (!(newParentPage == null || oldParentPage != null && oldParentPage.equals(newParentPage))) {
            newParentPage.addChild(topPage);
        }
        this.eventManager.publishEvent((Event)new ContentPermissionEvent(this, topPage, null));
        pagesToIndex.add(topPage);
        List attachments = topPage.getAttachments();
        for (Attachment a : attachments) {
            this.indexer.reIndex((Searchable)a);
        }
        if (moveChildren || newSpace.equals(oldSpace)) {
            List permittedChildren = this.contentPermissionManager.getPermittedChildren(topPage, user);
            for (Page permittedChild : permittedChildren) {
                this.moveHierarchyRecursive(permittedChild, topPage, newSpace, user, moveChildren, pagesToIndex);
                this.rebuildAncestors(permittedChild, pagesToIndex);
            }
            ArrayList notPermittedChildren = new ArrayList(topPage.getChildren());
            notPermittedChildren.removeAll(permittedChildren);
            this.orphanChildren(topPage, notPermittedChildren, pagesToIndex);
        } else {
            this.orphanChildren(topPage, new ArrayList(topPage.getChildren()), pagesToIndex);
        }
        this.eventManager.publishEvent((Event)new ContentPermissionEvent(this, topPage, null));
        this.indexer.reIndex(topPage);
    }

    private void orphanChildren(Page page, List children, List pagesToIndex) {
        for (Page child : children) {
            page.removeChild(child);
            this.rebuildAncestors(child, pagesToIndex);
        }
    }

    public Space createSpace(String key, String name, String description, User creator) {
        if (!Space.isValidGlobalSpaceKey(key)) {
            throw new IllegalArgumentException("Invalid space key.");
        }
        if (creator == null) {
            throw new IllegalArgumentException("Cannot create spaces anonymously. You must specify a valid user for creator.");
        }
        Space space = this.setupSpace(key, name.trim(), description);
        space.setSpaceType(SpaceType.GLOBAL);
        space.setCreatorName(creator.getName());
        this.saveSpace(space);
        this.spacePermissionManager.createInitialSpacePermissions(space);
        SpaceCreateEvent spaceCreateEvent = new SpaceCreateEvent(this, space);
        this.eventManager.publishEvent((Event)spaceCreateEvent);
        return space;
    }

    public Space createPersonalSpace(String name, String description, User owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Personal spaces can not be created for Anonymous users");
        }
        String key = "~" + owner.getName();
        if (!Space.isValidPersonalSpaceKey(key)) {
            throw new IllegalArgumentException("Invalid space key.");
        }
        Space space = this.setupSpace(key, name, description);
        space.setSpaceType(SpaceType.PERSONAL);
        space.setCreationDate(Calendar.getInstance().getTime());
        space.setCreatorName(owner.getName());
        this.saveSpaceNoEvent(space);
        this.spacePermissionManager.createInitialSpacePermissions(space);
        if (space.getDescription() == null) {
            this.createSpaceDescription(space);
        }
        this.labelManager.addLabel(space.getDescription(), new Label("favourite", Namespace.PERSONAL, owner.getName()));
        SpaceCreateEvent spaceCreateEvent = new SpaceCreateEvent(this, space);
        this.eventManager.publishEvent((Event)spaceCreateEvent);
        return space;
    }

    public Space getPersonalSpace(User user) {
        if (user == null) {
            return null;
        }
        return this.getPersonalSpace(user.getName());
    }

    public void convertToPersonalSpace(Space space, User owner, boolean updateLinks) {
        if (owner == null) {
            return;
        }
        String newSpaceKey = "~" + owner.getName();
        this.mailContentManager.removeAllMail(space);
        space.setSpaceType(SpaceType.PERSONAL);
        space.setCreatorName(owner.getName());
        space.setLastModifierName(owner.getName());
        this.changeSpaceKey(space, newSpaceKey, updateLinks);
        if (space.getDescription() == null) {
            this.createSpaceDescription(space);
        }
        this.labelManager.addLabel(space.getDescription(), new Label("favourite", Namespace.PERSONAL, owner.getName()));
        this.spacePermissionManager.createInitialSpacePermissions(space);
        SpaceConvertEvent spaceConvertEvent = new SpaceConvertEvent(this, space);
        this.eventManager.publishEvent((Event)spaceConvertEvent);
    }

    private SpaceDescription createSpaceDescription(Space space) {
        SpaceDescription spaceDescription = new SpaceDescription();
        spaceDescription.setSpace(space);
        spaceDescription.setContent("");
        space.setDescription(spaceDescription);
        this.saveSpace(space);
        return spaceDescription;
    }

    public long findPageTotal(Space space) {
        return this.spaceDao.findPageTotal(space);
    }

    public void setBandanaPersister(BandanaPersister bandanaPersister) {
        this.bandanaPersister = bandanaPersister;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setContentPermissionManager(ContentPermissionManager contentPermissionManager) {
        this.contentPermissionManager = contentPermissionManager;
    }

    public int getNumberOfBlogPosts(Space space) {
        return this.spaceDao.getNumberOfBlogPosts(space);
    }

    public int getNumberOfMail(Space space) {
        return this.spaceDao.getNumberOfMail(space);
    }

    public String getSpaceFromPageId(long pageId) {
        AbstractPage page = (AbstractPage)this.pageManager.getById(pageId);
        if (page != null) {
            return page.getSpaceKey();
        }
        return null;
    }

    public List getPages(Space space, boolean currentOnly) {
        return this.pageManager.getPages(space, currentOnly);
    }

    public List getPagesStartingWith(Space space, String s) {
        return this.pageManager.getPagesStartingWith(space, s);
    }

    public List getBlogPosts(Space space, boolean currentOnly) {
        return this.pageManager.getBlogPosts(space, currentOnly);
    }

    public List getMail(Space space, boolean currentOnly) {
        return this.mailContentManager.getMail(space, currentOnly);
    }

    public void ensureSpaceDescriptionExists(Space space) {
        if (space == null) {
            throw new IllegalArgumentException("space must not be null");
        }
        if (space.getDescription() == null) {
            SpaceDescription spaceDescription = new SpaceDescription();
            spaceDescription.setSpace(space);
            spaceDescription.setContent("");
            space.setDescription(spaceDescription);
            this.saveSpace(space);
        }
    }

    public List getSpaceContent(Space space, boolean currentOnly) {
        ArrayList content = new ArrayList();
        content.addAll(this.getPages(space, false));
        content.addAll(this.getBlogPosts(space, false));
        content.addAll(this.getMail(space, false));
        return content;
    }

    public List getSpacesCreatedAfter(Date creationDate) {
        return this.spaceDao.getSpacesCreatedAfter(creationDate);
    }

    public void setMailContentManager(MailContentManager mailContentManager) {
        this.mailContentManager = mailContentManager;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    private Space setupSpace(String key, String name, String description) {
        if (StringUtils.isBlank((String)key)) {
            throw new IllegalArgumentException("Key is blank. Cannot create space with no key.");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("Name is blank. Cannot create space with no name.");
        }
        Space space = new Space();
        space.setKey(key);
        space.setName(name);
        SpaceDescription spaceDescription = new SpaceDescription();
        spaceDescription.setSpace(space);
        spaceDescription.setContent(description);
        space.setDescription(spaceDescription);
        return space;
    }

    private void changeSpaceKey(Space space, String newSpaceKey, boolean updateLinks) {
        if (this.getSpace(newSpaceKey) != null) {
            return;
        }
        String oldSpaceKey = space.getKey();
        List pages = this.getPages(space, false);
        for (int i = 0; i < pages.size(); ++i) {
            Page page = (Page)pages.get(i);
            if (updateLinks) {
                this.pageManager.updateContentLinkingTo(page, newSpaceKey, null);
            }
            this.indexer.reIndex(page);
        }
        space.setKey(newSpaceKey);
        this.indexer.reIndex(space.getDescription());
        this.draftManager.updateSpaceKey(newSpaceKey, oldSpaceKey);
        this.spaceDao.save(space);
    }

    public String getPersonalSpaceKey(String username) {
        return "~" + username;
    }

    public void setIndexManager(ConfluenceIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public DraftManager getDraftManager() {
        return this.draftManager;
    }

    public void setDraftManager(DraftManager draftManager) {
        this.draftManager = draftManager;
    }

    private void saveSpaceNoEvent(Space space) {
        this.spaceDescriptionManager.saveContentEntity(space.getDescription(), null);
        this.spaceDao.save(space);
    }

    public void setPageTemplateManager(PageTemplateManager templateManager) {
        this.templateManager = templateManager;
    }
}

