/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.xwork.FileUploadUtils;
import org.apache.log4j.Category;

public abstract class AbstractLogoAction
extends ConfluenceActionSupport {
    protected static final Category log = Category.getInstance(AbstractLogoAction.class);
    protected FileUploadManager fileUploadManager;
    protected AttachmentManager attachmentManager;

    public abstract String doDisableLogo();

    public abstract String doEnableLogo();

    public abstract boolean isLogoDisabled();

    protected abstract ContentEntityObject getContentToAttachLogoTo();

    public abstract String getActionDescriminator();

    protected abstract String getAttachmentName();

    public String doDelete() {
        this.attachmentManager.removeAttachmentFromServer(this.attachmentManager.getAttachment(this.getContentToAttachLogoTo(), this.getAttachmentName()));
        return "success";
    }

    public Attachment getLogo() {
        return this.attachmentManager.getAttachment(this.getContentToAttachLogoTo(), this.getAttachmentName());
    }

    public String doUpload() {
        try {
            FileUploadUtils.UploadedFile uploadedFile = FileUploadUtils.getSingleUploadedFile();
            FileUploadUtils.UploadedFile file = new FileUploadUtils.UploadedFile(uploadedFile.getFile(), this.getAttachmentName(), uploadedFile.getContentType());
            this.fileUploadManager.storeFile(file, null, this.getContentToAttachLogoTo());
            return "success";
        }
        catch (FileUploadUtils.FileUploadException e) {
            log.debug((Object)"Either the requested logo could not be located or exceeds the maximum attachment size. Please double check the file you are uploading.", (Throwable)e);
            this.addActionError(this.getText("could.not.locate.uploaded.logo"));
            return "error";
        }
    }

    public void setFileUploadManager(FileUploadManager fileUploadManager) {
        this.fileUploadManager = fileUploadManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }
}

