/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.SpecialLabelFilter;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.core.util.filter.Filter;
import com.atlassian.core.util.filter.FilterChain;
import com.atlassian.core.util.filter.ListFilter;
import java.util.ArrayList;
import java.util.List;

public class AbstractSpaceLabelAction
extends AbstractSpaceAction {
    public List getTeamLabelsOnThisSpace() {
        return this.getLabelManager().getTeamLabelsForSpace(this.getSpaceKey());
    }

    public List getAvailableTeamLabels() {
        List result = this.getLabelManager().getTeamLabels();
        result.removeAll(this.getTeamLabelsOnThisSpace());
        return result;
    }

    public List getLabelsOnThisSpace() {
        ArrayList<Label> result = new ArrayList<Label>();
        for (Label label : this.getSpace().getDescription().getLabels()) {
            if (Namespace.isTeam(label)) continue;
            result.add(label);
        }
        FilterChain filterChain = new FilterChain();
        filterChain.addFilter((Filter)new SpecialLabelFilter());
        return new ListFilter((Filter)filterChain).filterList(result);
    }

    public List getSuggestedLabelsForSpace() throws Exception {
        return LabelUtil.getRecentAndPopularLabelsForEntity(this.getSpace().getDescription(), this.getLabelManager(), 20, this.getRemoteUser().getName());
    }
}

