/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.spaces.actions.AbstractSpaceLabelAction;
import com.atlassian.confluence.spaces.actions.SpaceAdministrative;
import com.atlassian.confluence.util.LabelUtil;
import java.util.List;

public class AddLabelToSpaceAction
extends AbstractSpaceLabelAction
implements SpaceAdministrative {
    private String newSpaceLabel;

    public void validate() {
        int totalLabelCount;
        int labelCount = LabelUtil.countLabels(this.newSpaceLabel);
        if (labelCount > 20) {
            String message = this.getText("labels.too.many.entries", new Integer[]{new Integer(labelCount), new Integer(20)});
            this.addActionError(message);
        }
        if ((totalLabelCount = labelCount + this.getLabelsOnThisSpace().size()) > 500) {
            String message = this.getText("labels.over.max", new Integer[]{new Integer(totalLabelCount), new Integer(500)});
            this.addActionError(message);
        }
    }

    public String execute() throws Exception {
        this.spaceManager.ensureSpaceDescriptionExists(this.getSpace());
        this.performSpaceLabelTransformations();
        List labelNames = LabelUtil.split(this.getNewSpaceLabel());
        for (String label : labelNames) {
            if (LabelParser.parse(label) != null) continue;
            this.addActionError("label.invalid.name", new String[]{label});
        }
        if (this.hasActionErrors()) {
            return "error";
        }
        for (String labelString : labelNames) {
            Label label = LabelUtil.addLabel(labelString, this.getLabelManager(), this.getSpace().getDescription());
            if (label != null) continue;
            this.addActionError("label.creation.failed", new String[]{labelString});
        }
        return "success";
    }

    public String getNewSpaceLabel() {
        return this.newSpaceLabel;
    }

    public void setNewSpaceLabel(String newSpaceLabel) {
        this.newSpaceLabel = newSpaceLabel;
    }

    public void performSpaceLabelTransformations() {
    }

    protected List getPermissionTypes() {
        List permissionTypes = super.getPermissionTypes();
        if (this.getSpace() != null) {
            this.addPermissionTypeTo("VIEWSPACE", permissionTypes);
            this.addPermissionTypeTo("SETSPACEPERMISSIONS", permissionTypes);
        }
        return permissionTypes;
    }
}

