/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.setup.settings.SpaceSettings;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.actions.AbstractLogoAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;

public class ConfigureSpaceLogoAction
extends AbstractLogoAction
implements SpaceAware {
    private Space space;

    public String doDisableLogo() {
        SpaceSettings spaceSettings = this.settingsManager.getSpaceSettings(this.getSpace().getKey());
        spaceSettings.setDisableLogo(true);
        this.settingsManager.updateSpaceSettings(spaceSettings);
        return "success";
    }

    public String doEnableLogo() {
        SpaceSettings spaceSettings = this.settingsManager.getSpaceSettings(this.getSpace().getKey());
        spaceSettings.setDisableLogo(false);
        this.settingsManager.updateSpaceSettings(spaceSettings);
        return "success";
    }

    public boolean isLogoDisabled() {
        return this.settingsManager.getSpaceSettings(this.getSpace().getKey()).isDisableLogo();
    }

    public String getActionDescriminator() {
        return "space";
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public Space getSpace() {
        return this.space;
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return false;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, this.getSpace());
    }

    protected SpaceDescription getContentToAttachLogoTo() {
        return this.getSpace().getDescription();
    }

    protected String getAttachmentName() {
        return this.getSpace().getKey();
    }
}

