/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.spaces.actions.EditSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAdministrative;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;

public class ConvertSpaceAction
extends EditSpaceAction
implements SpaceAdministrative {
    private boolean updateLinks;
    private String usersToAdd;

    public void validate() {
        super.validate();
        if (this.getUser() == null) {
            this.addFieldError("usererror", this.getText("error.no.valid.user"));
        }
        if (this.spaceManager.getSpace(this.getNewSpaceKey()) != null) {
            this.addFieldError("usererror", this.getText("error.user.has.personal.space", new String[]{this.getUser().getFullName()}));
        }
    }

    public String doConvert() throws Exception {
        User user = this.getUser();
        if (user != null) {
            this.spaceManager.convertToPersonalSpace(this.getSpace(), user, this.updateLinks);
            return "success";
        }
        return "error";
    }

    public String getNewSpaceKey() {
        User user = this.getUser();
        if (user == null) {
            return null;
        }
        return this.spaceManager.getPersonalSpaceKey(user.getName());
    }

    public User getUser() {
        User user = TextUtils.stringSet((String)this.usersToAdd) ? this.userAccessor.getUser(this.usersToAdd) : this.getRemoteUser();
        return user;
    }

    public boolean isUpdateLinks() {
        return this.updateLinks;
    }

    public void setUpdateLinks(boolean updateLinks) {
        this.updateLinks = updateLinks;
    }

    public String getUsersToAdd() {
        return this.usersToAdd;
    }

    public void setUsersToAdd(String usersToAdd) {
        this.usersToAdd = usersToAdd;
    }

    public int getNumberOfMail() {
        return this.spaceManager.getNumberOfMail(this.getSpace());
    }
}

