/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ListQuery;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.rss.FeedBuilder;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.LabelUtil;
import com.sun.syndication.feed.synd.SyndFeed;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CreateRssFeedAction
extends ConfluenceActionSupport {
    private static final String DEFAULT_RSS_TYPE = "rss";
    private static final String DEFAULT_SORT = "modified";
    private String rssType;
    private String sort;
    private String title;
    private List spaces;
    private List types;
    private List labels;
    private int maxResults;
    private int timeSpan;
    private boolean publicFeed;
    private String labelString;
    private SpaceManager spaceManager;
    private FeedBuilder feedBuilder;
    private boolean showDiff = true;
    private boolean showContent = true;

    public SyndFeed getSyndFeed() {
        ListQuery query = this.createListQuery();
        if (this.publicFeed) {
            return this.feedBuilder.createPublicFeed(query, this.showContent, this.showDiff);
        }
        return this.feedBuilder.createFeed(query, this.showContent, this.showDiff, this.getRemoteUser());
    }

    public String execute() throws Exception {
        return this.getRssType();
    }

    public String getRssType() {
        if (this.rssType == null) {
            return DEFAULT_RSS_TYPE;
        }
        return this.rssType;
    }

    public void setRssType(String rssType) {
        this.rssType = rssType;
    }

    public String getSort() {
        if (this.sort == null) {
            return DEFAULT_SORT;
        }
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setSpaces(List spaces) {
        this.spaces = spaces;
    }

    public void setTypes(List types) {
        this.types = types;
    }

    public void setLabels(List labels) {
        this.labels = labels;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setTimeSpan(int timeSpan) {
        this.timeSpan = timeSpan;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setPublicFeed(boolean publicFeed) {
        this.publicFeed = publicFeed;
    }

    public void setFeedBuilder(FeedBuilder feedBuilder) {
        this.feedBuilder = feedBuilder;
    }

    public String getLabelString() {
        return this.labelString;
    }

    public void setLabelString(String labelString) {
        this.labelString = labelString;
    }

    public boolean isShowDiff() {
        return this.showDiff;
    }

    public void setShowDiff(boolean showDiff) {
        this.showDiff = showDiff;
    }

    public boolean isShowContent() {
        return this.showContent;
    }

    public void setShowContent(boolean showContent) {
        this.showContent = showContent;
    }

    public List getLabels() {
        if (this.labels == null) {
            this.labels = new ArrayList();
            List labelNames = LabelUtil.split(this.getLabelString());
            for (int i = 0; i < labelNames.size(); ++i) {
                String labelName = (String)labelNames.get(i);
                Label label = this.labelManager.getLabel(labelName);
                if (label != null) {
                    this.labels.add(label);
                    continue;
                }
                this.labels.add(new Label(labelName));
            }
        }
        return this.labels;
    }

    public ListQuery createListQuery() {
        ListQuery query = new ListQuery();
        List spaces = this.createSpaceList(this.spaces);
        List spaceScopes = this.getSpaceScopes(this.spaces);
        ArrayList<String> sortList = new ArrayList<String>();
        sortList.add(this.sort);
        query.setName(this.title);
        query.setSpaceList(spaces);
        query.setSpaceScopes(spaceScopes);
        query.setTypeList(this.types);
        query.setStatusList(sortList);
        query.setMaxResults(this.maxResults);
        query.setTimeSpan(this.timeSpan);
        query.setLabelList(this.getLabels());
        if (this.publicFeed) {
            query.setUser(null);
        } else {
            query.setUser(this.getRemoteUser());
        }
        return query;
    }

    private List getSpaceScopes(List spaceKeys) {
        if (spaceKeys != null) {
            ArrayList<String> groupings = new ArrayList<String>();
            for (String key : spaceKeys) {
                if (!key.startsWith("conf_")) continue;
                groupings.add(key);
            }
            return groupings;
        }
        return Collections.EMPTY_LIST;
    }

    private List createSpaceList(List spaceList) {
        if (spaceList == null) {
            return Collections.EMPTY_LIST;
        }
        if (spaceList.contains("conf_all")) {
            return this.spaceManager.getPermittedSpaces(this.getRemoteUser());
        }
        ArrayList<Space> spaces = new ArrayList<Space>();
        for (int i = 0; i < spaceList.size(); ++i) {
            String spaceKey = (String)spaceList.get(i);
            Space s = this.spaceManager.getSpace(spaceKey);
            if (s == null) continue;
            spaces.add(s);
        }
        return spaces;
    }
}

