/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAdministrative;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.util.PairType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EditSpaceAction
extends AbstractSpaceAction
implements SpaceAdministrative {
    private String name;
    private String description;
    private List availablePages;
    private String selectedHomePage;
    private String spaceType;
    private List spaceTypes;
    private PersonalInformationManager personalInformationManager;
    private PageManager pageManager;

    public String getName() {
        if (this.name == null && this.getSpace() != null) {
            this.name = this.getSpace().getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        if (this.description == null && this.getSpace() != null && this.space.getDescription() != null) {
            this.description = this.getSpace().getDescription().getContent();
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSelectedHomePage() {
        if (this.selectedHomePage == null && this.getSpace() != null && this.getSpace().getHomePage() != null) {
            this.selectedHomePage = this.getSpace().getHomePage().getTitle();
        }
        return this.selectedHomePage;
    }

    public void setSelectedHomePage(String selectedHomePage) {
        this.selectedHomePage = selectedHomePage;
    }

    public List getAvailablePages() {
        if (this.availablePages == null && this.getSpace() != null) {
            this.availablePages = new ArrayList(this.pageManager.getPages(this.getSpace(), true));
            Page blankPageAtTop = new Page();
            blankPageAtTop.setTitle("");
            this.availablePages.add(0, blankPageAtTop);
        }
        Collections.sort(this.availablePages);
        return this.availablePages;
    }

    public String doEdit() throws Exception {
        this.getSpace().setName(this.name);
        if (this.getSpace().getDescription() == null) {
            this.getSpace().setDescription(new SpaceDescription(this.getSpace()));
        }
        this.getSpace().getDescription().setContent(this.description);
        this.getSpace().setHomePage(null);
        if (this.selectedHomePage != null && !this.selectedHomePage.equals("")) {
            for (Page page : this.pageManager.getPages(this.getSpace(), true)) {
                if (!page.getTitle().equals(this.selectedHomePage)) continue;
                this.getSpace().setHomePage(page);
                break;
            }
        }
        this.spaceManager.saveSpace(this.getSpace(), this.originalSpace);
        return "success";
    }

    public String getSpaceType() {
        return this.getText(this.getSpace().getSpaceType().toI18NKey());
    }

    public void setSpaceType(String spaceType) {
        this.spaceType = spaceType;
    }

    public boolean isConvertableToPersonalSpace() {
        if (this.getRemoteUser() == null || this.getSpace().isPersonal()) {
            return false;
        }
        if (GeneralUtil.isSuperUser(this.getRemoteUser()) || this.permissionManager.isConfluenceAdministrator(this.getRemoteUser())) {
            return true;
        }
        PersonalInformation info = this.personalInformationManager.getPersonalInformation(this.getRemoteUser().getName());
        return info != null && this.permissionManager.hasCreatePermission(this.getRemoteUser(), info, Space.class) && this.spaceManager.getPersonalSpace(this.getRemoteUser().getName()) == null;
    }

    public List getSpaceTypes() {
        if (this.spaceTypes == null) {
            this.spaceTypes = new ArrayList();
            this.spaceTypes.add(new PairType((Serializable)((Object)""), (Serializable)((Object)this.getText("space.name"))));
            this.spaceTypes.add(new PairType((Serializable)((Object)SpaceType.PERSONAL.toString()), (Serializable)((Object)this.getText("space.personal.name"))));
        }
        return this.spaceTypes;
    }

    public void setSpaceTypes(List spaceTypes) {
        this.spaceTypes = spaceTypes;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }
}

