/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.webwork.AbstractAwareInterceptor;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionInvocation;
import org.apache.log4j.Category;

public class SpaceAwareInterceptor
extends AbstractAwareInterceptor {
    private Category log = Category.getInstance(SpaceAwareInterceptor.class);
    private PermissionManager permissionManager;
    private SpaceManager spaceManager;

    public String intercept(ActionInvocation actionInvocation) throws Exception {
        UtilTimerStack.push((String)"SpaceAwareInterceptor.intercept()");
        Action action = actionInvocation.getAction();
        if (action instanceof SpaceAware) {
            SpaceAware spaceAware = (SpaceAware)action;
            Space space = this.getSpace();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Set space on SpaceAware " + action.getClass().getName() + ": " + space));
            }
            if (space != null) {
                spaceAware.setSpace(space);
            }
            if (spaceAware.isViewPermissionRequired() && (spaceAware.isSpaceRequired() || this.hasParameter("spaceKey") || this.hasParameter("key")) && !this.getPermissionManager().hasPermission(this.getUser(), Permission.VIEW, space)) {
                return this.getUser() == null ? "notpermitted" : "notfound";
            }
            if (space == null && spaceAware.isSpaceRequired()) {
                return "pagenotfound";
            }
        }
        UtilTimerStack.pop((String)"SpaceAwareInterceptor.intercept()");
        return actionInvocation.invoke();
    }

    private Space getSpace() {
        if (this.hasParameter("spaceKey")) {
            return this.getSpaceFromKey(this.getParameter("spaceKey"));
        }
        if (this.hasParameter("key")) {
            return this.getSpaceFromKey(this.getParameter("key"));
        }
        return null;
    }

    private Space getSpaceFromKey(String key) {
        if (Space.isValidSpaceKey(key)) {
            return this.getSpaceManager().getSpace(key);
        }
        return null;
    }

    private SpaceManager getSpaceManager() {
        if (this.spaceManager == null) {
            this.spaceManager = (SpaceManager)ContainerManager.getComponent((String)"spaceManager");
        }
        return this.spaceManager;
    }

    private PermissionManager getPermissionManager() {
        if (this.permissionManager == null) {
            this.permissionManager = (PermissionManager)ContainerManager.getComponent((String)"permissionManager");
        }
        return this.permissionManager;
    }
}

