/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceLabelAction;
import com.atlassian.confluence.util.ContentUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.util.Iterator;
import java.util.List;

public class ViewSpaceSummaryAction
extends AbstractSpaceLabelAction {
    private String name;
    private String description;
    private List recentlyUpdatedContent;
    private ContentEntityManager contentEntityManager;
    private CommentManager commentManager;

    public String execute() throws Exception {
        if (this.getSpace() == null) {
            ServletActionContext.getResponse().sendError(404, "Space not found: " + this.getKey());
            return "ERROR";
        }
        this.name = this.getSpace().getName();
        this.description = this.getSpace().getDescription() != null ? this.getSpace().getDescription().getContent() : "";
        return "success";
    }

    public List getRecentlyUpdatedContent() {
        if (this.recentlyUpdatedContent == null) {
            Iterator content = this.contentEntityManager.getRecentlyModifiedEntities(this.getSpace().getKey(), this.getMaxRecentChangesSize());
            Iterator comments = this.commentManager.getRecentlyUpdatedComments(this.getSpace(), this.getMaxRecentChangesSize());
            List updates = ContentUtils.mergeContentObjects(content, comments, this.getMaxRecentChangesSize());
            this.recentlyUpdatedContent = this.getPermittedEntitiesOf(updates);
        }
        return this.recentlyUpdatedContent;
    }

    public int getMaxRecentChangesSize() {
        return this.getUserInterfaceState().getMaxRecentChangesSize();
    }

    public void setMaxRecentChangesSize(int i) {
        this.getUserInterfaceState().setMaxRecentChangesSize(i);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ContentEntityManager getContentEntityManager() {
        return this.contentEntityManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public boolean isUserWatchingSpace() {
        if (this.isAnonymousUser()) {
            return false;
        }
        return this.notificationManager.getNotificationByUserAndSpace(this.getRemoteUser(), this.getSpaceKey()) != null;
    }

    public void setCommentManager(CommentManager commentManager) {
        this.commentManager = commentManager;
    }
}

