/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.listeners;

import com.atlassian.confluence.event.events.space.SpaceConvertEvent;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import org.apache.log4j.Category;

public class CreatePersonalSpaceListener
implements EventListener {
    private static final Category log = Category.getInstance(CreatePersonalSpaceListener.class);
    private PersonalInformationManager personalInformationManager;

    public void handleEvent(Event event) {
        Space space = null;
        if (event instanceof SpaceCreateEvent) {
            space = ((SpaceCreateEvent)event).getSpace();
        } else if (event instanceof SpaceConvertEvent) {
            space = ((SpaceConvertEvent)event).getSpace();
        } else {
            throw new UnsupportedOperationException("Unhandled event: " + event);
        }
        if (space.isPersonal()) {
            String username = space.getKey().substring("~".length());
            PersonalInformation newPersonalInfo = this.personalInformationManager.getPersonalInformation(username);
            try {
                PersonalInformation oldPersonalInfo = (PersonalInformation)newPersonalInfo.clone();
                newPersonalInfo.setContent(null);
                this.personalInformationManager.savePersonalInformation(newPersonalInfo, oldPersonalInfo);
            }
            catch (CloneNotSupportedException ex) {
                log.error((Object)"Exception while cloning personal information object", (Throwable)ex);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Blanked personal information content for user: " + username));
            }
        }
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{SpaceCreateEvent.class, SpaceConvertEvent.class};
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }
}

