/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.listeners;

import com.atlassian.confluence.event.events.content.user.PersonalInformationUpdateEvent;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import org.apache.log4j.Logger;

public class UpdatePersonalSpaceListener
implements EventListener {
    private static Logger log = Logger.getLogger(UpdatePersonalSpaceListener.class);
    private SpaceManager spaceManager;
    private UserAccessor userAccessor;

    public void handleEvent(Event event) {
        Space personalSpace;
        if (!(event instanceof PersonalInformationUpdateEvent)) {
            return;
        }
        PersonalInformationUpdateEvent updateEvent = (PersonalInformationUpdateEvent)event;
        PersonalInformation personalInfo = updateEvent.getPersonalInformation();
        PersonalInformation originalPersonalInfo = updateEvent.getOriginalPersonalInformation();
        if (personalInfo.getFullName() != null && originalPersonalInfo != null && !personalInfo.getFullName().equals(originalPersonalInfo.getFullName()) && (personalSpace = this.spaceManager.getPersonalSpace(this.userAccessor.getUser(personalInfo.getUsername()))) != null) {
            try {
                Space originalSpace = (Space)personalSpace.clone();
                personalSpace.setName(personalInfo.getFullName());
                this.spaceManager.saveSpace(personalSpace, originalSpace);
                log.info((Object)("Personal space name for user " + personalInfo.getUsername() + " has been updated to " + personalInfo.getFullName()));
            }
            catch (CloneNotSupportedException e) {
                log.error((Object)("Could not clone personal space? " + personalSpace));
            }
        }
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{PersonalInformationUpdateEvent.class};
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

