/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.persistence.dao.hibernate;

import com.atlassian.cache.Cache;
import com.atlassian.confluence.cache.CacheManagerKeys;
import com.atlassian.confluence.core.persistence.hibernate.ConfluenceHibernateObjectDao;
import com.atlassian.confluence.spaces.SpaceGroup;
import com.atlassian.confluence.spaces.persistence.dao.SpaceGroupDao;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.core.exception.InfrastructureException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import org.springframework.orm.hibernate.HibernateCallback;

public class HibernateSpaceGroupDao
extends ConfluenceHibernateObjectDao
implements SpaceGroupDao {
    protected EntityObject getByClassId(long l) {
        return super.getByClassId(l);
    }

    public SpaceGroup getById(long id) {
        SpaceGroup locatedSpaceGroup = (SpaceGroup)this.getByClassId(id);
        if (locatedSpaceGroup != null) {
            this.cacheSpaceGroupIdBySpaceGroupKey(locatedSpaceGroup.getKey(), locatedSpaceGroup.getId());
        }
        return locatedSpaceGroup;
    }

    public SpaceGroup getSpaceGroup(String spaceGroupKey) {
        SpaceGroup locatedSpaceGroup;
        if (spaceGroupKey == null) {
            return null;
        }
        Long spaceGroupId = this.getCachedSpaceGroupId(spaceGroupKey = spaceGroupKey.toLowerCase());
        if (spaceGroupId == null) {
            locatedSpaceGroup = (SpaceGroup)this.findSingleObject(this.findNamedQueryStringParam("confluence.spaceGroup_findBySpaceGroupKey", "spaceGroupKey", spaceGroupKey.toLowerCase(), true));
            if (locatedSpaceGroup == null) {
                return null;
            }
        } else {
            SpaceGroup locatedSpaceGroup2 = this.getById(spaceGroupId);
            if (locatedSpaceGroup2 != null && locatedSpaceGroup2.getKey() != null && locatedSpaceGroup2.getKey().toLowerCase().equals(spaceGroupKey)) {
                return locatedSpaceGroup2;
            }
            log.error((Object)("Found a bad spaceGroup id in the spaceGroup id cache which returned this: " + locatedSpaceGroup2 + ". Removing this id from the cache now."));
            try {
                this.getCache().remove((Object)spaceGroupKey);
            }
            catch (Exception e) {
                log.error((Object)("Unable to remove spaceGroupKey [" + spaceGroupKey + "]"), (Throwable)e);
            }
            return (SpaceGroup)this.findSingleObject(this.findNamedQueryStringParam("confluence.spaceGroup_findBySpaceGroupKey", "spaceGroupKey", spaceGroupKey.toLowerCase(), true));
        }
        this.cacheSpaceGroupIdBySpaceGroupKey(spaceGroupKey, locatedSpaceGroup.getId());
        return locatedSpaceGroup;
    }

    private Cache getCache() {
        return this.cacheFactory.getCache(CacheManagerKeys.CACHE_KEY_SPACEGROUP_KEY_TO_SPACEGROUPID);
    }

    public int findSpaceTotal(final SpaceGroup spaceGroup) {
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("confluence.spaceGroup_getSpaceCount");
                query.setParameter("spaceGroupId", (Object)new Long(spaceGroup.getId()));
                return query.iterate().next();
            }
        });
    }

    private Long getCachedSpaceGroupId(String spaceGroupKey) {
        try {
            Object value = this.getCache().get((Object)spaceGroupKey);
            if (value != null) {
                return (Long)value;
            }
            return null;
        }
        catch (InfrastructureException e) {
            log.error((Object)"Error while trying to fetch cached permission check result from to the cache!", (Throwable)e);
            return null;
        }
    }

    private void cacheSpaceGroupIdBySpaceGroupKey(String spaceGroupKey, long spaceGroupId) {
        this.getCache().put((Object)spaceGroupKey.toLowerCase(), (Object)new Long(spaceGroupId));
    }

    private void removeSpaceGroupFromCache(SpaceGroup spaceGroup) throws Exception {
        this.getCache().remove((Object)spaceGroup.getKey().toLowerCase());
    }

    public void remove(EntityObject entity) {
        if (entity instanceof SpaceGroup) {
            SpaceGroup spaceGroup = (SpaceGroup)entity;
            try {
                this.removeSpaceGroupFromCache(spaceGroup);
            }
            catch (Exception e) {
                log.error((Object)("Unable to remove SpaceGroup [" + spaceGroup + "] from cache"), (Throwable)e);
            }
        } else {
            log.error((Object)("SpaceGroupDao was asked to delete a: " + entity.getClass().getName()), (Throwable)new Exception("Recording Stack Trace"));
        }
        super.remove(entity);
    }

    public Class getPersistentClass() {
        return SpaceGroup.class;
    }
}

