/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.status.service;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.confluence.status.service.systeminfo.DatabaseInfo;
import com.atlassian.confluence.status.service.systeminfo.MemoryInfo;
import com.atlassian.confluence.status.service.systeminfo.SystemInfo;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.PluginAccessor;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Logger;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.HibernateTemplate;

public class DefaultSystemInformationService
implements SystemInformationService {
    private static final Logger logger = Logger.getLogger(DefaultSystemInformationService.class);
    private static String[] ISOLATION_LEVELS = new String[]{"Read committed", "Read uncommitted", "Read committed", null, "Repeatable read", null, null, null, "Serializable"};
    private BootstrapManager bootstrapManager;
    private SessionFactory sessionFactory;
    private PluginAccessor pluginAccessor;

    public ConfluenceInfo getConfluenceInfo() {
        if (!this.isInitializedWithLogging()) {
            return null;
        }
        ConfluenceInfo infoBean = new ConfluenceInfo();
        infoBean.setHome(this.bootstrapManager.getConfiguredApplicationHome());
        infoBean.setStartTime(GeneralUtil.getSystemStartupTime());
        infoBean.setVersion(GeneralUtil.getVersionNumber());
        infoBean.setBuildNumber(GeneralUtil.getBuildNumber());
        infoBean.setEnabledPlugins(this.pluginAccessor.getEnabledPlugins());
        return infoBean;
    }

    public DatabaseInfo getDatabaseInfo() {
        if (!this.isInitializedWithLogging()) {
            return null;
        }
        DatabaseInfo info = new DatabaseInfo();
        this.retrieveConnectionBasedInformation(info);
        this.retrieveConfluenceBasedInformation(info);
        this.findDatabaseQueryLatency(info);
        return info;
    }

    public SystemInfo getSystemProperties() {
        SystemInfo info = new SystemInfo();
        Date now = new Date();
        info.setDate(new SimpleDateFormat("EEEEE, dd MMM yyyy").format(now));
        info.setTime(new SimpleDateFormat("HH:mm:ss").format(now));
        info.setFavouriteColour("Sangria");
        Properties sysProps = System.getProperties();
        info.setJavaVersion(sysProps.getProperty("java.version"));
        info.setJavaVendor(sysProps.getProperty("java.vendor"));
        info.setJvmVersion(sysProps.getProperty("java.vm.specification.version"));
        info.setJvmVendor(sysProps.getProperty("java.vm.specification.vendor"));
        info.setJvmImplementationVersion(sysProps.getProperty("java.vm.version"));
        info.setJavaRuntime(sysProps.getProperty("java.runtime.name"));
        info.setJavaVm(sysProps.getProperty("java.vm.name"));
        info.setUserName(sysProps.getProperty("user.name"));
        info.setUserTimezone(sysProps.getProperty("user.timezone"));
        info.setOperatingSystem(sysProps.getProperty("os.name") + " " + sysProps.getProperty("os.version"));
        info.setOperatingSystemArchitecture(sysProps.getProperty("os.arch"));
        info.setFileSystemEncoding(sysProps.getProperty("file.encoding"));
        return info;
    }

    public MemoryInfo getMemoryInfo() {
        Runtime rt = Runtime.getRuntime();
        MemoryInfo info = new MemoryInfo();
        info.setFreeMemory(rt.freeMemory());
        info.setTotalMemory(rt.totalMemory());
        return info;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    private boolean isInitializedWithLogging() {
        if (this.pluginAccessor == null || this.bootstrapManager == null || this.sessionFactory == null) {
            logger.warn((Object)"The DefaultSystemInformationService has not been completely initialized so will not provide information about the system.");
            return false;
        }
        return true;
    }

    private void retrieveConnectionBasedInformation(final DatabaseInfo info) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.sessionFactory, true);
        try {
            hibernateTemplate.execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    DatabaseMetaData data = session.connection().getMetaData();
                    StringBuffer buf = new StringBuffer();
                    buf.append(data.getDriverMajorVersion()).append(".").append(data.getDriverMinorVersion());
                    info.setDriverVersion(buf.toString());
                    info.setVersion(data.getDatabaseProductVersion());
                    info.setName(data.getDatabaseProductName());
                    int isolationLevel = session.connection().getTransactionIsolation();
                    if (isolationLevel < 0 || isolationLevel >= ISOLATION_LEVELS.length) {
                        info.setIsolationLevel(null);
                    } else {
                        info.setIsolationLevel(ISOLATION_LEVELS[isolationLevel]);
                    }
                    return info;
                }
            });
        }
        catch (Exception ex) {
            logger.warn((Object)"Exception while retrieving database connection information.", (Throwable)ex);
        }
    }

    private void retrieveConfluenceBasedInformation(DatabaseInfo info) {
        info.setUrl(this.bootstrapManager.getString("hibernate.connection.url"));
        if (info.getUrl() == null) {
            info.setUrl(this.bootstrapManager.getString("hibernate.connection.datasource"));
        }
        info.setDialect(this.bootstrapManager.getString("hibernate.dialect"));
        info.setDriverName(this.bootstrapManager.getString("hibernate.connection.driver_class"));
    }

    private void findDatabaseQueryLatency(final DatabaseInfo info) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.sessionFactory, true);
        try {
            hibernateTemplate.execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Statement statement = session.connection().createStatement();
                    long startTime = System.currentTimeMillis();
                    statement.executeQuery("select * from CLUSTERSAFETY");
                    info.setExampleLatency(System.currentTimeMillis() - startTime);
                    return info;
                }
            });
        }
        catch (Exception ex) {
            logger.warn((Object)"Exception while testing database query latency.", (Throwable)ex);
        }
    }
}

