/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.themes;

import com.atlassian.confluence.plugin.descriptor.ThemeModuleDescriptor;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeStylesheet;
import com.atlassian.confluence.themes.ThemedDecorator;
import com.atlassian.confluence.util.GeneralUtil;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTheme
implements Theme {
    private ColourScheme colourScheme;
    private List decorators;
    private Collection<? extends ThemeStylesheet> stylesheets;
    private String pluginKey;
    private boolean includeClassicStyles;

    @Override
    public ColourScheme getColourScheme() {
        return this.colourScheme;
    }

    @Override
    public ThemedDecorator getDecorator(String path) {
        if (TextUtils.stringSet((String)path)) {
            for (ThemedDecorator decorator : this.decorators) {
                if (!decorator.getName().equals(path)) continue;
                return decorator;
            }
        }
        return null;
    }

    @Override
    public Collection<? extends ThemeStylesheet> getStylesheets() {
        return this.stylesheets;
    }

    @Override
    public String getPluginKey() {
        return this.pluginKey;
    }

    @Override
    public boolean isIncludeClassicStyles() {
        return this.includeClassicStyles;
    }

    @Override
    public void init(ThemeModuleDescriptor moduleDescriptor) {
        this.pluginKey = moduleDescriptor.getPluginKey();
        this.colourScheme = moduleDescriptor.getColourScheme();
        this.decorators = moduleDescriptor.getLayouts();
        this.stylesheets = Collections.unmodifiableList(new ArrayList(moduleDescriptor.getStylesheets()));
        Map params = moduleDescriptor.getParams();
        this.includeClassicStyles = GeneralUtil.convertToBoolean(params.get("includeClassicStyles"), true);
    }
}

