/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.themes;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.labels.DisplayableLabel;
import com.atlassian.confluence.labels.actions.ViewLabelAction;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.Spaced;
import com.atlassian.confluence.themes.ThemeHelper;
import com.atlassian.confluence.util.I18NSupport;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.breadcrumbs.BreadcrumbGenerator;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.Action;
import java.util.List;

public class GlobalHelper
implements ThemeHelper {
    private ConfluenceActionSupport action;
    private Space space;
    private AbstractPage abstractPage;
    private DisplayableLabel label;
    private BootstrapManager bootstrapManager;
    private WikiStyleRenderer wikiStyleRenderer;

    public GlobalHelper() {
    }

    public GlobalHelper(ConfluenceActionSupport action) {
        this.action = action;
    }

    @HtmlSafe
    public String getText(String property) {
        if (this.action != null) {
            return this.action.getText(property);
        }
        return I18NSupport.getText(property);
    }

    public ConfluenceActionSupport getAction() {
        return this.action;
    }

    public String getDomainName() {
        if (this.bootstrapManager == null) {
            this.bootstrapManager = (BootstrapManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"bootstrapManager");
        }
        return this.bootstrapManager.getBaseUrl();
    }

    public String getSiteTitle() {
        String title = this.action.getGlobalSettings().getSiteTitle();
        if (title != null) {
            return title;
        }
        return "Confluence";
    }

    public Space getSpace() {
        if (this.space == null) {
            if (this.action instanceof Spaced) {
                Spaced spaced = (Spaced)((Object)this.action);
                this.space = spaced.getSpace();
            } else if (this.getPage() != null) {
                this.space = this.getPage().getSpace();
                if (this.space == null && !this.getPage().isLatestVersion()) {
                    this.space = this.getPage().getOriginalVersionPage().getSpace();
                }
            }
        }
        return this.space;
    }

    public String getSpaceKey() {
        if (this.getSpace() != null) {
            return this.getSpace().getKey();
        }
        return null;
    }

    public String getSpaceName() {
        if (this.getSpace() != null) {
            return this.getSpace().getName();
        }
        return null;
    }

    public String getSpaceType() {
        if (this.getSpace() != null) {
            return this.getSpace().getSpaceType().toString();
        }
        return null;
    }

    public AbstractPage getPage() {
        if (this.abstractPage == null && this.action instanceof PageAware) {
            PageAware pageAware = (PageAware)((Object)this.action);
            this.abstractPage = pageAware.getPage();
        }
        return this.abstractPage;
    }

    public WikiStyleRenderer getWikiStyleRenderer() {
        if (this.wikiStyleRenderer == null) {
            this.wikiStyleRenderer = (WikiStyleRenderer)ContainerManager.getInstance().getContainerContext().getComponent((Object)"wikiStyleRenderer");
        }
        return this.wikiStyleRenderer;
    }

    @HtmlSafe
    public String renderConfluenceMacro(String wikiCall) {
        PageContext pageContext = this.getPage() != null ? new PageContext(this.getPage()) : (this.getSpace() != null ? new PageContext(this.getSpaceKey()) : new PageContext());
        return this.getWikiStyleRenderer().convertWikiToXHtml((RenderContext)pageContext, wikiCall);
    }

    public DisplayableLabel getLabel() {
        if (this.label == null && this.action instanceof ViewLabelAction) {
            ViewLabelAction viewLabelAction = (ViewLabelAction)this.action;
            this.label = viewLabelAction.getLabel();
        }
        return this.label;
    }

    public List getBreadcrumbs() {
        BreadcrumbGenerator generator = new BreadcrumbGenerator(this);
        Breadcrumb breadcrumb = generator.getBreadcrumb((Action)this.action, ServletActionContext.getRequest());
        return breadcrumb.getBreadcrumbsTrail();
    }
}

