/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.themes;

import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.actions.AbstractPageAction;
import com.atlassian.confluence.pages.actions.TinyUrlAware;
import com.atlassian.confluence.pages.actions.ViewPageAction;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.themes.GlobalHelper;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.breadcrumbs.PageBreadcrumb;
import com.atlassian.spring.container.ContainerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PageHelper
extends GlobalHelper
implements TinyUrlAware {
    private static final int DEFAULT_COMMENT_UPDATE_DISPLAY_THRESHOLD = 600;
    private AttachmentManager attachmentManager;
    private LabelManager labelManager;
    private List displayLabels;
    private Integer numberOfAttachments;
    private SettingsManager settingsManager;

    public PageHelper() {
    }

    public PageHelper(AbstractPageAction action) {
        super(action);
    }

    public boolean isHistoricalVersion() {
        if (this.getPage() != null) {
            return !this.getPage().isLatestVersion();
        }
        return false;
    }

    public boolean isChildrenShowing() {
        ViewPageAction viewPageAction = null;
        if (this.getAction() instanceof ViewPageAction) {
            viewPageAction = (ViewPageAction)this.getAction();
            return viewPageAction.getChildrenShowing();
        }
        return false;
    }

    public int getNumberOfAttachments() {
        if (this.numberOfAttachments == null) {
            this.numberOfAttachments = new Integer(0);
            if (this.attachmentManager == null) {
                this.attachmentManager = (AttachmentManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"attachmentManager");
            }
            if (this.getPage() instanceof BlogPost) {
                this.numberOfAttachments = new Integer(this.attachmentManager.getLatestVersionsOfAttachments((BlogPost)this.getPage()).size());
            }
            if (this.getPage() != null) {
                this.numberOfAttachments = new Integer(this.attachmentManager.getLatestVersionsOfAttachments(this.getPage()).size());
            }
        }
        return this.numberOfAttachments;
    }

    public String getTinyUrl() {
        if (this.getAction() instanceof AbstractPageAction) {
            AbstractPageAction abstractPageAction = (AbstractPageAction)this.getAction();
            return abstractPageAction.getTinyUrl();
        }
        return null;
    }

    public LabelManager getLabelManager() {
        if (this.labelManager == null) {
            this.labelManager = (LabelManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"labelManager");
        }
        return this.labelManager;
    }

    public List getViewableLabels() {
        if (this.getPage() == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.displayLabels == null) {
            this.displayLabels = this.getPage().getLabelsForDisplay(this.getAction().getRemoteUser());
        }
        return this.displayLabels;
    }

    public boolean shouldRenderCommentAsUpdated(Comment comment, int thresholdSeconds) {
        if (comment.getLastModifierName() == null) {
            return false;
        }
        return !comment.getLastModifierName().equals(comment.getCreatorName()) || comment.getLastModificationDate().getTime() - comment.getCreationDate().getTime() > (long)(thresholdSeconds * 1000);
    }

    public boolean shouldRenderCommentAsUpdated(Comment comment) {
        return this.shouldRenderCommentAsUpdated(comment, 600);
    }

    public List getEllipsisCrumbs(List breadcrumbs) {
        if (this.settingsManager == null) {
            this.settingsManager = (SettingsManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"settingsManager");
        }
        int numberOfVisibleAncestors = this.settingsManager.getGlobalSettings().getNumberOfBreadcrumbAncestors();
        ArrayList<Breadcrumb> ellipsisCrumbs = new ArrayList<Breadcrumb>();
        boolean firstPageFound = false;
        for (int i = breadcrumbs.size() - 1; i >= 0; --i) {
            Breadcrumb breadcrumb = (Breadcrumb)breadcrumbs.get(i);
            if (!(breadcrumb instanceof PageBreadcrumb)) continue;
            if (!firstPageFound) {
                firstPageFound = true;
                continue;
            }
            if (--numberOfVisibleAncestors >= 0) continue;
            ellipsisCrumbs.add(0, breadcrumb);
        }
        return ellipsisCrumbs;
    }
}

